/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexerPB;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AmbiguityHandlerPB {
    private LocationIndexerPB indexer = null;
    private String[] tilesets = new String[]{"n", "a1", "a2", "a3", "a4", "a5"};

    public void setIndexer(LocationIndexerPB indexer) {
        this.indexer = indexer;
    }

    private int[] countTypes(Set<ISMLocation> iLocations) {
        if (iLocations == null || iLocations.size() == 0) {
            return null;
        }
        int len = this.tilesets.length;
        int[] typeCount = new int[len];
        for (int i = 0; i < len; ++i) {
            typeCount[i] = 0;
        }
        for (ISMLocation location : iLocations) {
            for (int i = 0; i < len; ++i) {
                ArrayList<ISMLocation> list = new ArrayList<ISMLocation>();
                list.add(location);
                if (!this.locationCanBe(this.tilesets[i], location)) continue;
                int n = i;
                typeCount[n] = typeCount[n] + 1;
            }
        }
        return typeCount;
    }

    private boolean isAncestor(Integer ancestorId, Integer locId) {
        List<Integer> path = this.indexer.getPathToRoot(locId);
        return path.contains(ancestorId);
    }

    private boolean locationCanBe(String mapidList, ISMLocation location) {
        List<Integer> locIds = this.indexer.getLocationIds(location);
        if (locIds == null) {
            return false;
        }
        for (Integer locId : locIds) {
            LocationEntry entry = this.indexer.getLocation(locId);
            String mapid = entry.getMapId();
            if (!mapid.equals(mapidList)) continue;
            return true;
        }
        return false;
    }

    public JSONObject processAmbiguousList(Set<ISMLocation> iLocations, Integer ancestorId) {
        JSONObject resultJSON = new JSONObject();
        JSONObject resolvedIds = new JSONObject();
        JSONArray ambiguous = new JSONArray();
        int[] types = this.countTypes(iLocations);
        int locationCount = iLocations.size();
        ArrayList<String> sameTypes = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (!((double)types[i] > (double)locationCount * 0.8)) continue;
            sameTypes.add(this.tilesets[i]);
        }
        if (sameTypes.size() > 0) {
            String ancestorMapId;
            String type = (String)sameTypes.get(0);
            if (sameTypes.size() > 1 && (ancestorMapId = this.indexer.getLocation(ancestorId).getMapId()).equals(type)) {
                type = (String)sameTypes.get(1);
            }
            JSONObject resolvedLocations = this.resolveLocationsUsingTypeAndAncestor(iLocations, type, ancestorId);
            resultJSON.put((Object)"resolvedIds", resolvedLocations.get((Object)"locIds"));
            ambiguous = (JSONArray)resolvedLocations.get((Object)"ambiguous");
            if (ambiguous != null) {
                resultJSON.put((Object)"ambiguous", (Object)ambiguous);
            }
        } else {
            for (ISMLocation iLocation : iLocations) {
                String name;
                List<Integer> locIds = this.indexer.getLocationIds(iLocation);
                if (locIds == null || locIds.isEmpty() || !this.isAmbiguous(name = iLocation.getName())) continue;
                if (locIds.size() > 1) {
                    ambiguous.add((Object)name);
                }
                resolvedIds.put((Object)iLocation.toString(), (Object)locIds.get(0));
            }
            resultJSON.put((Object)"resolvedIds", (Object)resolvedIds);
            resultJSON.put((Object)"ambiguous", (Object)ambiguous);
        }
        return resultJSON;
    }

    public boolean isAmbiguous(String name) {
        List<Integer> locIds = this.indexer.getLocationIdsForName(name);
        if (locIds == null) {
            return false;
        }
        if (locIds.size() < 2) {
            return false;
        }
        int count = 0;
        LocationEntry entry = null;
        for (Integer locId : locIds) {
            entry = this.indexer.getLocation(locId);
            LocationEntry.Type type = entry.getType();
            if (type == LocationEntry.Type.CITY) continue;
            ++count;
        }
        return count > 1;
    }

    private JSONObject resolveLocationsUsingTypeAndAncestor(Set<ISMLocation> iLocations, String type, Integer ancestorId) {
        JSONArray ambiguous = new JSONArray();
        JSONObject result = new JSONObject();
        JSONObject locidsObject = new JSONObject();
        LocationEntry ancestor = this.indexer.getLocation(ancestorId);
        Iterator<ISMLocation> i$ = iLocations.iterator();
        block0: while (i$.hasNext()) {
            List<Integer> locIds;
            ISMLocation iLocation;
            ISMLocation iLocation1 = iLocation = i$.next();
            if (ancestorId > 33) {
                ArrayList<ISMLocation> ancestryList = new ArrayList<ISMLocation>();
                List<ISMLocation> ancestryList1 = iLocation.getAncestryLocations();
                if (ancestryList1 == null) {
                    ancestryList.add(new SMLocation(ancestor.getName()));
                    iLocation1 = new SMLocation(iLocation.getName(), ancestryList);
                }
            }
            if ((locIds = this.indexer.getLocationIds(iLocation1, type)).isEmpty()) continue;
            String name = iLocation.getName();
            if (locIds.size() == 1) {
                locidsObject.put((Object)iLocation.toString(), (Object)locIds.get(0));
                continue;
            }
            for (Integer locId : locIds) {
                LocationEntry entry = this.indexer.getLocation(locId);
                if (name.length() == 2 && !entry.getAliases().contains(name) || !entry.getMapId().equals(type) || !this.isAncestor(ancestorId, locId)) continue;
                locidsObject.put((Object)iLocation.toString(), (Object)locId);
                if (iLocation.getAncestryLocations() == null) {
                    if (entry.getMapId().startsWith("n")) continue block0;
                    ambiguous.add((Object)name);
                    continue block0;
                }
                ambiguous.add((Object)name);
                continue block0;
            }
        }
        result.put((Object)"locIds", (Object)locidsObject);
        if (!ambiguous.isEmpty()) {
            result.put((Object)"ambiguous", (Object)ambiguous);
        }
        return result;
    }
}

