/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.json.java.JSONArray;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GeoJSONCoordinates {
    private String type = "";
    private GeometryObject<?> coordinates = null;

    public GeoJSONCoordinates() {
    }

    public GeoJSONCoordinates(String type, JSONArray coordArray) {
        this.type = type;
        this.createObjectFromArray(coordArray);
    }

    public Object getCoordinates() {
        return this.coordinates;
    }

    private void createObjectFromArray(JSONArray coordArray) {
        this.coordinates = this.type.equals("Polygon") ? new Polygon(coordArray) : (this.type.equals("MultiPolygon") ? new MultiPolygon(coordArray) : null);
    }

    public String compareTo(GeoJSONCoordinates otherCoordinates) {
        String otherCoordStr;
        StringBuffer error = new StringBuffer();
        if (!this.type.equals(otherCoordinates.getType())) {
            return "Different types";
        }
        String coordStr = this.coordinates.toString();
        if (!coordStr.equals(otherCoordStr = otherCoordinates.getCoordinates().toString()) && this.type.equals("Polygon")) {
            Polygon polygon = (Polygon)this.coordinates;
            error.append(polygon.compareTo((Polygon)otherCoordinates.getCoordinates()));
        }
        return error.toString();
    }

    public String comparePolygons(JSONArray array, JSONArray otherArray) {
        LatLong element;
        int i;
        StringBuffer error = new StringBuffer();
        otherArray = (JSONArray)otherArray.get(0);
        array = (JSONArray)array.get(0);
        ArrayList<LatLong> list = new ArrayList<LatLong>();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            if (array.get(i2) instanceof Double) {
                System.out.println();
            }
            LatLong element2 = new LatLong((JSONArray)array.get(i2));
            list.add(element2);
        }
        ArrayList<LatLong> otherList = new ArrayList<LatLong>();
        for (i = 0; i < otherArray.size(); ++i) {
            element = new LatLong((JSONArray)otherArray.get(i));
            otherList.add(element);
            if (list.contains(element)) continue;
            error.append("Not found in the first list:" + element + "\n");
        }
        for (i = 0; i < list.size(); ++i) {
            element = (LatLong)list.get(i);
            if (otherList.contains(element)) continue;
            error.append("Not found in the second list:" + element + "\n");
        }
        return error.toString();
    }

    public String getType() {
        return this.type;
    }

    public JSONArray getJSONArray() {
        if (this.coordinates == null) {
            return new JSONArray();
        }
        if (this.coordinates instanceof Polygon) {
            Polygon polygon = (Polygon)this.coordinates;
            return polygon.getJSONArray();
        }
        if (this.coordinates instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)this.coordinates;
            return multiPolygon.getJSONArray();
        }
        return null;
    }

    public String toString() {
        if (this.coordinates == null) {
            return "[]";
        }
        return this.coordinates.toString();
    }

    public GeoJSONCoordinates get(int index) {
        if (!this.type.equals("MultiPolygon")) {
            return null;
        }
        List<?> allData = this.coordinates.getData();
        if (index >= allData.size()) {
            return null;
        }
        Polygon polygon = (Polygon)allData.get(index);
        return new GeoJSONCoordinates("Polygon", polygon.getJSONArray());
    }

    public void remove(int index) {
        List<?> data = this.coordinates.getData();
        data.remove(index);
    }

    public static class MultiPolygon
    extends GeometryObject<Polygon> {
        public MultiPolygon(JSONArray coordArray) {
            for (int i = 0; i < coordArray.size(); ++i) {
                JSONArray coordElement = (JSONArray)coordArray.get(i);
                Polygon polygon = new Polygon(coordElement);
                if (polygon.getJSONArray().isEmpty()) continue;
                this.data.add(polygon);
            }
        }

        public JSONArray getJSONArray() {
            JSONArray array = new JSONArray();
            for (int i = 0; i < this.data.size(); ++i) {
                array.add((Object)((Polygon)this.data.get(i)).getJSONArray());
            }
            return array;
        }
    }

    private static class Polygon
    extends GeometryObject<LinearRing> {
        public Polygon(JSONArray coordArray) {
            for (int i = 0; i < coordArray.size(); ++i) {
                JSONArray coordElement = (JSONArray)coordArray.get(i);
                if ((coordElement = LinearRing.validate(coordElement)) == null) continue;
                LinearRing lr = new LinearRing(coordElement);
                this.data.add(lr);
            }
        }

        public String compareTo(Polygon otherCoordinates) {
            String otherCoordStr;
            String coordStr = this.data.toString();
            if (!coordStr.equals(otherCoordStr = otherCoordinates.getData().toString())) {
                return "not the same polygons";
            }
            return "";
        }

        public JSONArray getJSONArray() {
            JSONArray array = new JSONArray();
            for (int i = 0; i < this.data.size(); ++i) {
                array.add((Object)((LinearRing)this.data.get(i)).getJSONArray());
            }
            return array;
        }
    }

    private static class LinearRing
    extends GeometryObject<LatLong> {
        public LinearRing(JSONArray array) {
            this.data = new ArrayList();
            for (int i = 0; i < array.size(); ++i) {
                JSONArray element = (JSONArray)array.get(i);
                if (element.size() != 2) continue;
                this.data.add(new LatLong(element));
            }
        }

        public static JSONArray validate(JSONArray array) {
            int lastIndex = array.size() - 1;
            if (lastIndex < 3) {
                return null;
            }
            if (!array.get(0).equals(array.get(lastIndex))) {
                array.add(array.get(0));
            }
            return array;
        }

        public JSONArray getJSONArray() {
            JSONArray array = new JSONArray();
            for (int i = 0; i < this.data.size(); ++i) {
                array.add((Object)((LatLong)this.data.get(i)).getJSONArray());
            }
            return array;
        }
    }

    private static abstract class GeometryObject<E> {
        protected List<E> data = new ArrayList();

        public List<E> getData() {
            return this.data;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("[");
            for (int i = 0; i < this.data.size(); ++i) {
                result.append(this.data.get(i).toString());
                if (i >= this.data.size() - 1) continue;
                result.append(", ");
            }
            return result.toString();
        }
    }

    private static class LatLong {
        private double latitude = 0.0;
        private double longitude = 0.0;

        public LatLong(JSONArray array) {
            this.latitude = (Double)array.get(1);
            this.longitude = (Double)array.get(0);
        }

        public JSONArray getJSONArray() {
            JSONArray array = new JSONArray();
            array.add((Object)this.longitude);
            array.add((Object)this.latitude);
            return array;
        }

        public String toString() {
            return "[" + this.longitude + ", " + this.latitude + "]";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LatLong)) {
                return false;
            }
            LatLong otherLatLong = (LatLong)obj;
            return this.longitude == otherLatLong.longitude && this.latitude == otherLatLong.latitude;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.longitude).toHashCode();
        }
    }
}

