/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.GeoJSONGeometry;
import com.ibm.json.java.JSONObject;

public class GeoJSONFeature {
    private GeoJSONGeometry geometry = new GeoJSONGeometry();
    private String name = "";
    private JSONObject properties = new JSONObject();

    public GeoJSONFeature(String featureString) {
        this.createObjectFromString(featureString);
    }

    public GeoJSONFeature() {
    }

    private void createObjectFromString(String featureStr) {
        JSONObject featureJSON = null;
        try {
            featureJSON = JSONObject.parse((String)featureStr);
        }
        catch (Exception e) {
            this.name = "";
            return;
        }
        JSONObject geometry1 = (JSONObject)featureJSON.get((Object)"geometry");
        this.properties = (JSONObject)featureJSON.get((Object)"properties");
        this.name = (String)this.properties.get((Object)"name");
        this.geometry = new GeoJSONGeometry(geometry1.toString());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.properties.put((Object)"name", (Object)name);
    }

    public GeoJSONGeometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(GeoJSONGeometry geometry) {
        this.geometry = geometry;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put((Object)key, (Object)value);
    }

    public JSONObject getJSON() {
        JSONObject geoJsonObj = new JSONObject();
        geoJsonObj.put((Object)"type", (Object)"Feature");
        geoJsonObj.put((Object)"geometry", (Object)this.geometry.getJSON());
        geoJsonObj.put((Object)"properties", (Object)this.properties);
        return geoJsonObj;
    }

    public String toString() {
        return this.getJSON().toString();
    }

    public String compareTo(GeoJSONFeature otherFeature) {
        String error = "";
        if (!this.getProperties().equals((Object)otherFeature.getProperties())) {
            error = error + "Different properties \n1. " + this.getProperties() + "\n2. " + otherFeature.getProperties();
        }
        GeoJSONGeometry geometry = this.getGeometry();
        GeoJSONGeometry otherGeometry = otherFeature.getGeometry();
        if ((error = error + geometry.compareTo(otherGeometry)).length() > 0) {
            error = "Error in feature " + this.getName() + ":\n" + error;
        }
        return error;
    }
}

