/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.GeoJSONCoordinates;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

public class GeoJSONGeometry {
    private String type = "";
    private GeoJSONCoordinates coordinates = new GeoJSONCoordinates();

    public GeoJSONGeometry() {
    }

    public GeoJSONGeometry(String geometryString) {
        this.createObjectFromString(geometryString);
    }

    private void createObjectFromString(String geometryString) {
        JSONObject geometryJSON = null;
        try {
            geometryJSON = JSONObject.parse((String)geometryString);
        }
        catch (Exception e) {
            this.type = "";
            return;
        }
        this.type = (String)geometryJSON.get((Object)"type");
        JSONArray coordinates1 = (JSONArray)geometryJSON.get((Object)"coordinates");
        this.coordinates = new GeoJSONCoordinates(this.type, coordinates1);
    }

    public GeoJSONCoordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(GeoJSONCoordinates coordinates) {
        this.coordinates = coordinates;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JSONObject getJSON() {
        JSONObject geoJsonObj = new JSONObject();
        geoJsonObj.put((Object)"type", (Object)this.type);
        JSONArray coordinatesArray = new JSONArray();
        coordinatesArray = this.coordinates.getJSONArray();
        geoJsonObj.put((Object)"coordinates", (Object)coordinatesArray);
        return geoJsonObj;
    }

    public String toString() {
        return this.getJSON().toString();
    }

    public String compareTo(GeoJSONGeometry otherGeometry) {
        String error = "";
        if (!this.type.equals(otherGeometry.getType())) {
            error = error + "Different Types " + this.type + " " + otherGeometry.getType();
        } else {
            GeoJSONCoordinates otherCoordinates = otherGeometry.getCoordinates();
            error = error + this.coordinates.compareTo(otherCoordinates);
        }
        return error;
    }
}

