/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.GeoJSONFeature;
import com.ibm.athena.smartermaps.model.GeoJSONGeometry;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class GeoJSONObject {
    private List<GeoJSONFeature> features = new ArrayList<GeoJSONFeature>();
    private String type = "";

    public GeoJSONObject(LocationEntry entry) {
        String entryString = entry.getGeoJSON();
        this.createObjectFromString(entryString);
    }

    public GeoJSONObject(String entryString) {
        this.createObjectFromString(entryString);
    }

    public GeoJSONObject() {
    }

    public GeoJSONFeature getFeature(String featureName) {
        for (int i = 0; i < this.features.size(); ++i) {
            GeoJSONFeature feature = this.features.get(i);
            if (!feature.getName().equals(featureName)) continue;
            return feature;
        }
        return null;
    }

    public GeoJSONFeature getFeature(String featureName, String propertyName, String value) {
        for (int i = 0; i < this.features.size(); ++i) {
            JSONObject propObj;
            GeoJSONFeature feature = this.features.get(i);
            if (!feature.getName().equals(featureName) || !(propObj = feature.getProperties()).get((Object)propertyName).equals(value)) continue;
            return feature;
        }
        return null;
    }

    public void removeFeature(String featureName) {
        for (int i = 0; i < this.features.size(); ++i) {
            GeoJSONFeature feature = this.features.get(i);
            if (!feature.getName().equals(featureName)) continue;
            this.features.remove(i);
            return;
        }
    }

    public int getFeatureCount(String featureName) {
        int count = 0;
        for (int i = 0; i < this.features.size(); ++i) {
            GeoJSONFeature feature = this.features.get(i);
            if (!feature.getName().equals(featureName)) continue;
            ++count;
        }
        return count;
    }

    public List<GeoJSONFeature> getFeatures() {
        return this.features;
    }

    public String getType() {
        return this.type;
    }

    public GeoJSONGeometry getGeometry(String featureName) {
        GeoJSONFeature feature = this.getFeature(featureName);
        if (feature != null) {
            return feature.getGeometry();
        }
        return null;
    }

    public JSONObject getJSON() {
        JSONObject geoJsonObj = new JSONObject();
        if (this.features == null) {
            geoJsonObj.put((Object)"type", (Object)"");
            geoJsonObj.put((Object)"features", (Object)new JSONArray());
            return geoJsonObj;
        }
        geoJsonObj.put((Object)"type", (Object)"FeatureCollection");
        JSONArray featuresArray = new JSONArray();
        for (int i = 0; i < this.features.size(); ++i) {
            featuresArray.add((Object)this.features.get(i).getJSON());
        }
        geoJsonObj.put((Object)"features", (Object)featuresArray);
        return geoJsonObj;
    }

    public String toString() {
        JSONObject obj = this.getJSON();
        if (obj == null) {
            // empty if block
        }
        return this.getJSON().toString();
    }

    public void addFeature(JSONObject feature) {
        this.features.add(new GeoJSONFeature(feature.toString()));
    }

    private void createObjectFromString(String entryString) {
        JSONObject geoJSON = new JSONObject();
        try {
            geoJSON = JSONObject.parse((String)entryString);
        }
        catch (Exception e) {
            this.features = null;
            return;
        }
        JSONArray features1 = (JSONArray)geoJSON.get((Object)"features");
        this.features = new ArrayList<GeoJSONFeature>();
        for (int i = 0; i < features1.size(); ++i) {
            JSONObject feature = (JSONObject)features1.get(i);
            this.features.add(new GeoJSONFeature(feature.toString()));
        }
    }

    public String compareTo(GeoJSONObject otherJSON) {
        List<GeoJSONFeature> otherFeatures;
        int otherFeaturesSize;
        StringBuffer errors = new StringBuffer();
        int featuresSize = this.features.size();
        if (featuresSize != (otherFeaturesSize = (otherFeatures = otherJSON.getFeatures()).size())) {
            String name;
            int i;
            errors.append("\nDifferent feature sizes:" + featuresSize + "," + otherFeaturesSize + " , missing:\n");
            ArrayList<String> featureList = new ArrayList<String>();
            ArrayList<String> otherFeatureList = new ArrayList<String>();
            for (i = 0; i < featuresSize; ++i) {
                featureList.add(this.features.get(i).getName());
            }
            for (i = 0; i < otherFeaturesSize; ++i) {
                name = otherFeatures.get(i).getName();
                otherFeatureList.add(name);
            }
            for (i = 0; i < featuresSize; ++i) {
                name = this.features.get(i).getName();
                if (otherFeatureList.contains(name)) continue;
                errors.append(name + ", ");
            }
            for (i = 0; i < otherFeaturesSize; ++i) {
                name = otherFeatures.get(i).getName();
                if (featureList.contains(name)) continue;
                errors.append(name + ", ");
            }
        }
        if (errors.length() > 0) {
            return errors.toString();
        }
        HashMap<String, GeoJSONFeature> featureMap = new HashMap<String, GeoJSONFeature>();
        HashMap<String, GeoJSONFeature> otherFeatureMap = new HashMap<String, GeoJSONFeature>();
        GeoJSONFeature feature = null;
        GeoJSONFeature otherFeature = null;
        for (int i = 0; i < featuresSize; ++i) {
            feature = this.features.get(i);
            otherFeature = otherFeatures.get(i);
            featureMap.put(feature.getName(), feature);
            otherFeatureMap.put(otherFeature.getName(), otherFeature);
        }
        Set keys = featureMap.keySet();
        for (String key : keys) {
            feature = (GeoJSONFeature)featureMap.get(key);
            otherFeature = (GeoJSONFeature)otherFeatureMap.get(key);
            if (otherFeature == null) {
                errors.append("\nFeature " + key + " not found in the other json: ");
                continue;
            }
            errors.append(feature.compareTo(otherFeature));
        }
        return errors.toString();
    }
}

