/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LocationEntry {
    private String countryCode = "";
    private String name = "";
    private String iso2Name = "";
    private List<String> aliases = new ArrayList<String>();
    private Type type;
    private List<Integer> parents = new ArrayList<Integer>();
    private List<Integer> children = new ArrayList<Integer>();
    private List<String> childrenNames = new ArrayList<String>();
    private String geoJSON = "";
    private int pop = 0;
    private String mapId = "";
    private String mapTileLevelId = "";
    private String pk = "";
    private String pointLayer = "";
    private String polyLayer = "";
    private String path = "";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LocationEntry(String name) {
        this.name = name;
    }

    public LocationEntry(String name, List<String> aliases, Type type, List<Integer> parents, List<String> childrenNames, String geoJSON) {
        this.name = name;
        if (aliases != null && !aliases.isEmpty()) {
            this.aliases = aliases;
            for (String alias : aliases) {
                if (alias.length() != 2) continue;
                char c0 = alias.charAt(0);
                char c1 = alias.charAt(1);
                if (!Character.isUpperCase(c0) || !Character.isUpperCase(c1)) continue;
                this.iso2Name = alias;
                break;
            }
        }
        this.type = type;
        if (parents != null) {
            this.parents = parents;
        }
        if (childrenNames != null) {
            this.childrenNames = childrenNames;
        }
        this.geoJSON = geoJSON;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Type getType() {
        return this.type;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public String getPointLayer() {
        return this.pointLayer;
    }

    public void setPointLayer(String pointLayer) {
        this.pointLayer = pointLayer;
    }

    public String getPolyLayer() {
        return this.polyLayer;
    }

    public void setPolyLayer(String polyLayer) {
        this.polyLayer = polyLayer;
    }

    public List<Integer> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public Integer getFirstParentId() {
        if (this.parents.size() == 0) {
            return null;
        }
        return this.parents.get(0);
    }

    public List<Integer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void setChildren(List<Integer> newChildren) {
        this.children = newChildren;
    }

    public List<String> getChildrenNames() {
        return this.childrenNames;
    }

    public String getGeoJSON() {
        return this.geoJSON;
    }

    public void setGeoJSON(String geoJSON) {
        this.geoJSON = geoJSON;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public String getIso2Name() {
        return this.iso2Name;
    }

    public int getPop() {
        return this.pop;
    }

    public void setPop(int pop) {
        this.pop = pop;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapTileLevelId = mapId;
        this.mapId = mapId.matches("a[1-5].*") ? mapId.substring(0, 2) : mapId;
    }

    public String getTileLevelMapId() {
        return this.mapTileLevelId;
    }

    public void addChild(Integer locationId) {
        if (locationId != null) {
            this.children.add(locationId);
        }
    }

    public void addChildName(String name) {
        this.childrenNames.add(name);
    }

    public void addAlias(String alias) {
        if (alias != null && !this.aliases.contains(alias)) {
            this.aliases.add(alias.trim());
        }
    }

    public void addParent(Integer parent) {
        this.parents.add(parent);
    }

    public String toString() {
        return "name=" + this.name + " ,path=" + this.path + ", pk:" + this.pk + ", mapId:" + this.mapId + ", parent:" + this.getFirstParentId() + ", Aliases:" + this.aliases + ", Children:" + this.children + ", Children names:" + this.childrenNames;
    }

    public static enum Type {
        WORLD,
        CONTINENT,
        SUBREGION,
        COUNTRY,
        PROVINCE,
        CITY,
        GROUP,
        REGION,
        COUNTY;

    }
}

