/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.model.AddressIndex;
import com.ibm.athena.smartermaps.model.AmbiguityHandler;
import com.ibm.athena.smartermaps.model.GeoJSONCoordinates;
import com.ibm.athena.smartermaps.model.GeoJSONFeature;
import com.ibm.athena.smartermaps.model.GeoJSONObject;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationTableHandler;
import com.ibm.athena.smartermaps.util.MapsUtilities;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class LocationIndexer {
    private static final String CUSTOMER_ALIASES_RESOURCE = "/mapFiles/customerAliases.txt";
    public static final String UNITED_STATES_OF_AMERICA = "United States of America";
    private static final LocationIndexer INSTANCE = new LocationIndexer();
    public static final String CHINA_TAIWAN_PROPERTY = "ChinaTaiwanPrecedence";
    public static final String CHINA = "China";
    public static final String TAIWAN = "Taiwan";
    public static final String INDIA_PAKISTAN_PROPERTY = "IndiaPakistanPrecedence";
    public static final String INDIA = "India";
    public static final String PAKISTAN = "Pakistan";
    public static final String JAMMU_AND_KASHMIR = "Jammu and Kashmir";
    public static final String NORTHERN_AREAS = "Northern Areas";
    public static final String ISRAEL_WEST_BANK_PROPERTY = "IsraelWestBankPrecedence";
    public static final String ISRAEL = "Israel";
    public static final String WEST_BANK = "West Bank";
    private Map<Integer, LocationEntry> locationTable = null;
    private MapsUtilities mapUtilities = new MapsUtilities();
    private AmbiguityHandler ambiguityHandler = new AmbiguityHandler();
    private LocationTableHandler locationTableHandler = null;
    private boolean useMapbox = false;
    private static final String ALASKA = "Alaska";
    private static final String HAWAII = "Hawaii";
    private static final String PUERTO_RICO = "Puerto Rico";
    private static final String GUAM = "Guam";

    private LocationIndexer() {
        this.ambiguityHandler.setIndexer(this);
        this.locationTableHandler = new LocationTableHandler();
        try {
            this.locationTable = this.locationTableHandler.getLocationTable();
            this.addCustomerAliases();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LocationIndexer getInstance() {
        return INSTANCE;
    }

    public List<AddressIndex> getAllNames() {
        ArrayList<AddressIndex> allNames = new ArrayList<AddressIndex>();
        Set<Integer> keys = this.locationTable.keySet();
        for (Integer locId : keys) {
            LocationEntry locationEntry = this.locationTable.get(locId);
            String name = locationEntry.getName();
            allNames.add(new AddressIndex(name, locId));
            List<String> aliases = locationEntry.getAliases();
            if (aliases.size() <= 0) continue;
            for (int i = 0; i < aliases.size(); ++i) {
                allNames.add(new AddressIndex(aliases.get(i), locId));
            }
        }
        return allNames;
    }

    public JSONObject getFeatureForName(JSONObject geoJSON, LocationEntry entry) {
        JSONArray featuresObjArr = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name = propObj.get((Object)"name").toString();
            if (!this.equalsNameOrAlias(name, entry)) continue;
            return featureObj;
        }
        return null;
    }

    public LocationEntry getLocation(Integer locationId) {
        return this.locationTable.get(locationId);
    }

    public List<Integer> getLocationIds(String name) {
        List<Integer> ids = this.locationTableHandler.getAllLocationIds(name);
        ArrayList<Integer> ids1 = new ArrayList<Integer>();
        if (ids == null) {
            return null;
        }
        for (Integer id : ids) {
            if (this.getLocation(id).getType() == LocationEntry.Type.CITY) continue;
            ids1.add(id);
        }
        return ids1;
    }

    public List<Integer> getLocationIds(ISMLocation iLocation, LocationEntry.Type type) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<Integer> allIds = this.getLocationIds(iLocation);
        if (allIds == null) {
            return ids;
        }
        for (Integer id : allIds) {
            if (type != null && this.getLocation(id).getType() != type) continue;
            ids.add(id);
        }
        return ids;
    }

    private Integer getNearestCommonAncestorId(List<Integer> locIds, List<DisputedTerritories> dTerritories) {
        if (locIds == null || locIds.size() < 1) {
            return null;
        }
        if (locIds.size() == 1) {
            return (Integer)locIds.toArray()[0];
        }
        List<Integer> path = null;
        Integer first = null;
        for (Integer locId : locIds) {
            if (locId == null) continue;
            if (first == null) {
                first = locId;
                path = this.getPathToRoot(locId, dTerritories);
                continue;
            }
            List<Integer> path1 = this.getPathToRoot(locId, dTerritories);
            path = this.getCommonPath(path, path1);
        }
        int size = path.size() - 1;
        return (Integer)path.get(size);
    }

    private Integer getParentIdWithDisputedTerritories(Integer locId, List<DisputedTerritories> dTerritories) {
        if (dTerritories == null) {
            return null;
        }
        if (dTerritories.contains((Object)DisputedTerritories.IsraelPrecedence) && this.hasAncestor(locId, WEST_BANK)) {
            return this.getLocationIds(ISRAEL).get(0);
        }
        if (dTerritories.contains((Object)DisputedTerritories.PakistanPrecedence) && this.hasAncestor(locId, JAMMU_AND_KASHMIR)) {
            return this.getLocationIds(PAKISTAN).get(0);
        }
        if (!dTerritories.contains((Object)DisputedTerritories.TaiwanPrecedence) && this.hasAncestor(locId, TAIWAN)) {
            return this.getLocationIds(CHINA).get(0);
        }
        if (!dTerritories.contains((Object)DisputedTerritories.PakistanPrecedence) && this.hasAncestor(locId, NORTHERN_AREAS)) {
            return this.getLocationIds(INDIA).get(0);
        }
        return null;
    }

    private boolean hasAncestor(Integer locId, String name) {
        LocationEntry entry = this.getLocation(locId);
        if (entry == null || entry.getParents() == null) {
            return false;
        }
        while (!entry.getParents().isEmpty()) {
            if (entry.getName().equals(name)) {
                return true;
            }
            locId = entry.getFirstParentId();
            if ((entry = this.getLocation(locId)) != null && entry.getParents() != null) continue;
            return false;
        }
        return false;
    }

    public boolean isAncestor(Integer smallestAncestorId, Integer locId, List<DisputedTerritories> dTerritories) {
        if (smallestAncestorId == locId) {
            return false;
        }
        String ancestorName = this.getLocation(smallestAncestorId).getName();
        if (ancestorName.equals(UNITED_STATES_OF_AMERICA)) {
            LocationEntry entry = this.getLocation(locId);
            String locationName = entry.getName();
            if (entry.getType() == LocationEntry.Type.COUNTRY && this.isUSTerritory(locationName)) {
                return true;
            }
        }
        List<Integer> path = this.getPathToRoot(locId, dTerritories);
        return path.contains(smallestAncestorId);
    }

    public boolean isAncestor(String ancestor, String name, List<DisputedTerritories> dTerritories) {
        List<Integer> ancestorIds = this.getLocationIds(ancestor);
        List<Integer> nameIds = this.getLocationIds(name);
        if (ancestorIds == null || ancestorIds.size() == 0 || nameIds == null || nameIds.size() == 0) {
            return false;
        }
        for (int i = 0; i < ancestorIds.size(); ++i) {
            for (int j = 0; j < nameIds.size(); ++j) {
                if (!this.isAncestor(ancestorIds.get(i), nameIds.get(j), dTerritories)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized JSONObject getSmallestGeoJSON(Map<ISMLocation, Integer> locationMap, List<DisputedTerritories> dTerritories, boolean boundingRegion) {
        JSONObject geoJSON = new JSONObject();
        if (locationMap.isEmpty()) {
            return geoJSON;
        }
        Integer ancestorId = null;
        JSONObject statesAndTerritories = this.containsUSStatesAndTerritoriesOnly(locationMap.keySet());
        boolean mapCompleted = true;
        for (Map.Entry<ISMLocation, Integer> entry : locationMap.entrySet()) {
            if (entry.getValue() != null) continue;
            mapCompleted = false;
            break;
        }
        if (mapCompleted && statesAndTerritories == null) {
            ArrayList<Integer> locIds = new ArrayList<Integer>();
            locIds.addAll(locationMap.values());
            ancestorId = this.getNearestCommonAncestorId(locIds, dTerritories);
            String errors = this.ambiguityHandler.locationsThatContainOtherLocation(locIds, dTerritories);
            if (errors.length() > 0) {
                geoJSON.put((Object)"errors", (Object)errors);
                return geoJSON;
            }
        } else {
            Integer id;
            String name;
            JSONObject extendedCountries = this.containsExtendedCountries(locationMap.keySet());
            ArrayList<Integer> locIds = new ArrayList<Integer>();
            for (Integer locId : locationMap.values()) {
                if (locId == null) continue;
                locIds.add(locId);
            }
            if (statesAndTerritories != null) {
                for (ISMLocation key : locationMap.keySet()) {
                    name = key.getName();
                    id = (Integer)statesAndTerritories.get((Object)name);
                    if (id == null) continue;
                    locationMap.put(key, id);
                }
                ancestorId = this.getLocationIds(UNITED_STATES_OF_AMERICA).get(0);
            } else if (extendedCountries != null) {
                for (ISMLocation key : locationMap.keySet()) {
                    name = key.getName();
                    id = (Integer)extendedCountries.get((Object)name);
                    if (extendedCountries.get((Object)name) == null) continue;
                    locIds.add(id);
                    locationMap.put(key, id);
                }
                ancestorId = this.getNearestCommonAncestorId(locIds, dTerritories);
            } else {
                ancestorId = this.getNearestCommonAncestorIdForLocations(locationMap.keySet(), dTerritories);
                JSONObject ambiguityResult = this.ambiguityHandler.processAmbiguousList(locationMap.keySet(), dTerritories, ancestorId);
                String errors = (String)ambiguityResult.get((Object)"errors");
                if (errors != null && errors.length() > 0) {
                    return ambiguityResult;
                }
                JSONObject resolvedIds = (JSONObject)ambiguityResult.get((Object)"resolvedIds");
                for (ISMLocation key : locationMap.keySet()) {
                    Integer id2;
                    String name2 = key.getName();
                    if (locationMap.get(key) != null || (id2 = (Integer)resolvedIds.get((Object)name2)) == null) continue;
                    locationMap.put(key, id2);
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.addAll(locationMap.values());
                ancestorId = this.getNearestCommonAncestorId(list, dTerritories);
            }
        }
        LocationEntry ancestor = this.getLocation(ancestorId);
        if (ancestor == null) {
            return null;
        }
        ArrayList<String> locationNames = new ArrayList<String>();
        for (ISMLocation key : locationMap.keySet()) {
            locationNames.add(this.normalize(key.getName()));
        }
        if (boundingRegion) {
            ancestorId = 1;
            ancestor = this.getLocation(ancestorId);
        }
        String geoJSONString = null;
        if (ancestor.getType() == LocationEntry.Type.CITY) {
            Integer parent = ancestor.getFirstParentId();
            ancestor = this.locationTable.get(parent);
        }
        geoJSONString = this.getGeoJSON(ancestor);
        ArrayList<Integer> locIds = new ArrayList<Integer>();
        locIds.addAll(locationMap.values());
        for (Integer locId : locationMap.values()) {
            LocationEntry entry = this.getLocation(locId);
            if (entry != null) continue;
            return null;
        }
        try {
            geoJSON = JSONObject.parse((String)geoJSONString);
            geoJSON = this.resolveContinentsAndSubRegions(geoJSON, locIds, dTerritories);
            geoJSON = this.resolveHierarchy(geoJSON, ancestor, locIds);
            geoJSON = this.replaceRegions(geoJSON, locationMap);
            geoJSON = this.processEurope(geoJSON, ancestor, locIds);
            geoJSON = this.addCounties(geoJSON, locationMap, ancestor);
            geoJSON.put((Object)"mapName", (Object)ancestor.getName());
            geoJSON.put((Object)"mapId", (Object)ancestorId);
            geoJSON = this.processUS48or50(geoJSON, ancestor, locIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (ISMLocation key : locationMap.keySet()) {
            List<Integer> locIds2;
            LocationEntry entry;
            Integer locId = locationMap.get(key);
            String locNameInitial = key.getName();
            if (locNameInitial.equals((entry = this.getLocation(locId)).getName()) || (locIds2 = this.getLocationIds(locNameInitial)) == null || !locIds2.contains(locId)) continue;
            this.locationTableHandler.replaceNameInGeoJSON(geoJSON, entry, locNameInitial);
        }
        JSONArray ids = new JSONArray();
        for (Integer id : locIds) {
            ids.add((Object)id);
        }
        geoJSON.put((Object)"ids", (Object)ids);
        return geoJSON;
    }

    private JSONObject processEurope(JSONObject geoJSON, LocationEntry mapEntry, List<Integer> locIds) {
        GeoJSONObject europeGJ;
        GeoJSONFeature featRussia;
        String mapName = mapEntry.getName();
        if ((mapName.equals("Europe") || mapName.equals("Eastern Europe")) && (featRussia = (europeGJ = new GeoJSONObject(geoJSON.toString())).getFeature("Russia")) != null) {
            GeoJSONCoordinates coord = featRussia.getGeometry().getCoordinates();
            JSONArray array = coord.getJSONArray();
            JSONArray newCoordinatesObjArr = this.mapUtilities.processEuropeanRussia(array);
            GeoJSONCoordinates coord1 = new GeoJSONCoordinates("MultiPolygon", newCoordinatesObjArr);
            featRussia.getGeometry().setCoordinates(coord1);
            europeGJ.removeFeature("Russia");
            europeGJ.addFeature(featRussia.getJSON());
            return europeGJ.getJSON();
        }
        return geoJSON;
    }

    public Integer getNearestCommonAncestorIdForLocations(Set<ISMLocation> iLocations, List<DisputedTerritories> dTerritories) {
        if (iLocations == null || iLocations.size() < 1) {
            return null;
        }
        if (iLocations.size() == 1) {
            ISMLocation iLocation = (ISMLocation)iLocations.toArray()[0];
            List<Integer> locIds = this.getLocationIds(iLocation);
            if (locIds == null || locIds.isEmpty()) {
                return null;
            }
            return locIds.get(0);
        }
        int ind = this.getCommonParent(iLocations);
        if (ind > 0) {
            return ind;
        }
        ind = this.getCommonGrandParent(iLocations);
        if (ind > 0) {
            return ind;
        }
        int len = iLocations.size();
        int ind1 = 0;
        int ind2 = 1;
        ISMLocation iLocation1 = (ISMLocation)iLocations.toArray()[ind1];
        List<Integer> ids1 = this.getLocationIds(iLocation1);
        ISMLocation iLocation2 = (ISMLocation)iLocations.toArray()[ind2];
        List<Integer> ids2 = this.getLocationIds(iLocation2);
        List<Object> maxPath = new ArrayList();
        for (Integer id1 : ids1) {
            List<Integer> path1 = this.getPathToRoot(id1, dTerritories);
            for (Integer id2 : ids2) {
                List<Integer> path2 = this.getPathToRoot(id2, dTerritories);
                if (path1.containsAll(path2)) {
                    maxPath = path1;
                    continue;
                }
                if (path2.containsAll(path1)) {
                    maxPath = path2;
                    continue;
                }
                List<Integer> commonPath = this.getCommonPath(path1, path2);
                if (maxPath.size() >= commonPath.size()) continue;
                maxPath.clear();
                maxPath.addAll(commonPath);
                if (maxPath.size() != 1) continue;
                return 1;
            }
        }
        ++ind2;
        while (ind2 < len) {
            iLocation2 = (ISMLocation)iLocations.toArray()[ind2];
            ids2 = this.getLocationIds(iLocation2);
            ArrayList<Integer> maxPath1 = new ArrayList<Integer>();
            for (Integer id2 : ids2) {
                List<Integer> path2 = this.getPathToRoot(id2, dTerritories);
                List<Integer> commonPath = this.getCommonPath(maxPath, path2);
                if (maxPath1.size() >= commonPath.size()) continue;
                maxPath1.clear();
                maxPath1.addAll(commonPath);
            }
            maxPath.clear();
            maxPath.addAll(maxPath1);
            if (maxPath.size() == 1) {
                return 1;
            }
            ++ind2;
        }
        int size = maxPath.size() - 1;
        Integer root = 0;
        root = size == 0 ? Integer.valueOf(1) : (Integer)maxPath.get(size);
        return root;
    }

    public Integer getCommonParent(Set<ISMLocation> iLocations) {
        ISMLocation iLocation = (ISMLocation)iLocations.toArray()[0];
        Set<Integer> parentIds = this.getParentIds(iLocation);
        for (int i = 1; i < iLocations.size(); ++i) {
            iLocation = (ISMLocation)iLocations.toArray()[i];
            Set<Integer> pIds = this.getParentIds(iLocation);
            parentIds.retainAll(pIds);
            if (!parentIds.isEmpty()) continue;
            return 0;
        }
        return (Integer)parentIds.toArray()[0];
    }

    public Integer getCommonGrandParent(Set<ISMLocation> iLocations) {
        LocationEntry entry;
        ISMLocation iLocation = (ISMLocation)iLocations.toArray()[0];
        Set<Integer> parentIds = this.getParentIds(iLocation);
        HashSet<Integer> grandParentIds = new HashSet<Integer>();
        Iterator<Integer> itr = parentIds.iterator();
        while (itr.hasNext()) {
            entry = this.getLocation(itr.next());
            grandParentIds.addAll(entry.getParents());
        }
        for (int i = 1; i < iLocations.size(); ++i) {
            iLocation = (ISMLocation)iLocations.toArray()[i];
            parentIds = this.getParentIds(iLocation);
            HashSet<Integer> gpIds = new HashSet<Integer>();
            itr = parentIds.iterator();
            while (itr.hasNext()) {
                entry = this.getLocation(itr.next());
                gpIds.addAll(entry.getParents());
            }
            grandParentIds.retainAll(gpIds);
            if (!grandParentIds.isEmpty()) continue;
            return 0;
        }
        return (Integer)grandParentIds.toArray()[0];
    }

    private Set<Integer> getParentIds(ISMLocation iLocation) {
        HashSet<Integer> result = new HashSet<Integer>();
        List<Integer> ids = this.getLocationIds(iLocation);
        if (ids == null) {
            return result;
        }
        for (int i = 0; i < ids.size(); ++i) {
            LocationEntry id = this.getLocation(ids.get(i));
            result.addAll(id.getParents());
        }
        return result;
    }

    public boolean isParent(Integer parentId, Integer childId) {
        LocationEntry entry = this.getLocation(parentId);
        if (entry == null || entry.getChildren() == null) {
            return false;
        }
        return entry.getChildren().contains(childId);
    }

    public boolean isGrandParent(Integer parentId, Integer childId) {
        LocationEntry entry = this.getLocation(parentId);
        for (Integer id : entry.getChildren()) {
            if (!this.isParent(id, childId)) continue;
            return true;
        }
        return false;
    }

    private JSONObject addCounties(JSONObject geoJSON, Map<ISMLocation, Integer> locationMap, LocationEntry ancestor) throws IOException {
        ArrayList<Integer> locIds = new ArrayList<Integer>();
        locIds.addAll(locationMap.values());
        if (!this.containsType(locIds, LocationEntry.Type.COUNTY)) {
            return geoJSON;
        }
        HashMap<Integer, String> namesMap = new HashMap<Integer, String>();
        for (ISMLocation iLocation : locationMap.keySet()) {
            namesMap.put(locationMap.get(iLocation), iLocation.getName());
        }
        List<Integer> statesWithCounties = this.getStatesWithCounties(locIds);
        String countyGeoJSONString = "{\"type\":\"FeatureCollection\",\"features\":[]}";
        JSONObject countyGeoJSON = JSONObject.parse((String)countyGeoJSONString);
        JSONArray features = new JSONArray();
        for (Integer locId : statesWithCounties) {
            LocationEntry stateWithCounties = this.locationTable.get(locId);
            String stateGeoJSONString = stateWithCounties.getGeoJSON();
            JSONObject stateGeoJSON = null;
            try {
                stateGeoJSON = JSONObject.parse((String)stateGeoJSONString);
            }
            catch (Exception e) {
                continue;
            }
            JSONArray stateFeatures = (JSONArray)stateGeoJSON.get((Object)"features");
            JSONArray newStateFeatures = new JSONArray();
            for (int i = 0; i < stateFeatures.size(); ++i) {
                JSONArray coord;
                JSONObject feat = (JSONObject)stateFeatures.get(i);
                JSONObject newFeatObj = new JSONObject();
                JSONObject propObj = (JSONObject)feat.get((Object)"properties");
                String name = (String)propObj.get((Object)"name");
                String state = (String)propObj.get((Object)"state");
                JSONObject newPropObj = new JSONObject();
                newPropObj.put((Object)"state", (Object)state);
                newPropObj.put((Object)"name", (Object)name);
                newFeatObj.put((Object)"properties", (Object)newPropObj);
                newFeatObj.put((Object)"type", (Object)"Feature");
                Integer i2 = this.getLocationId(name, state, LocationEntry.Type.COUNTY);
                String name1 = (String)namesMap.get(i2);
                if (name1 != null) {
                    newPropObj.put((Object)"name", (Object)name1);
                }
                JSONObject geometryObj = (JSONObject)feat.get((Object)"geometry");
                JSONObject newGeometry = new JSONObject();
                String type = (String)geometryObj.get((Object)"type");
                newGeometry.put((Object)"type", (Object)type);
                JSONArray newCoord = coord = (JSONArray)geometryObj.get((Object)"coordinates");
                newGeometry.put((Object)"coordinates", (Object)newCoord);
                newFeatObj.put((Object)"geometry", (Object)newGeometry);
                newStateFeatures.add((Object)newFeatObj);
            }
            features.addAll((Collection)newStateFeatures);
        }
        countyGeoJSON.put((Object)"features", (Object)features);
        geoJSON.put((Object)"counties", (Object)countyGeoJSON);
        return geoJSON;
    }

    private boolean containsType(List<Integer> locIds, LocationEntry.Type type) {
        for (Integer locId : locIds) {
            if (this.locationTable.get(locId).getType() != type) continue;
            return true;
        }
        return false;
    }

    private List<Integer> getStatesWithCounties(List<Integer> locIds) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer locId : locIds) {
            LocationEntry entry = this.locationTable.get(locId);
            if (entry.getType() != LocationEntry.Type.COUNTY || result.contains(locId = entry.getFirstParentId())) continue;
            result.add(locId);
        }
        return result;
    }

    private JSONObject resolveContinentsAndSubRegions(JSONObject geoJSON, List<Integer> locIds, List<DisputedTerritories> dTerritories) {
        JSONObject result = geoJSON;
        for (Integer locId : locIds) {
            Integer n;
            Integer n2;
            ArrayList<Integer> countryIds;
            LocationEntry entry = this.getLocation(locId);
            if (entry == null) continue;
            if (entry.getType() == LocationEntry.Type.SUBREGION) {
                result = this.mergePolygons(result, entry.getName(), entry.getChildren(), dTerritories);
                continue;
            }
            if (entry.getType() == LocationEntry.Type.CONTINENT) {
                countryIds = new ArrayList<Integer>();
                List<Integer> subregionIds = entry.getChildren();
                for (int i = 0; i < subregionIds.size(); ++i) {
                    LocationEntry subregionEntry = this.getLocation(subregionIds.get(i));
                    countryIds.addAll(subregionEntry.getChildren());
                }
                result = this.mergePolygons(result, entry.getName(), countryIds, dTerritories);
                continue;
            }
            if (entry.getType() != LocationEntry.Type.WORLD) continue;
            countryIds = new ArrayList();
            Integer id = 0;
            do {
                n2 = id;
                n = id = Integer.valueOf(id + 1);
            } while ((entry = this.locationTable.get(id)).getType() != LocationEntry.Type.COUNTRY);
            do {
                countryIds.add(id);
                n2 = id;
                n = id = Integer.valueOf(id + 1);
            } while ((entry = this.locationTable.get(id)).getType() == LocationEntry.Type.COUNTRY);
            result = this.mergePolygons(result, "World", countryIds, dTerritories);
        }
        return result;
    }

    private JSONObject replaceRegions(JSONObject geoJSON, Map<ISMLocation, Integer> locationMap) {
        HashMap<String, ArrayList<String>> countriesWithRegions = new HashMap<String, ArrayList<String>>();
        HashMap<String, String> region2region = new HashMap<String, String>();
        JSONObject newGeoJson = new JSONObject();
        newGeoJson.put((Object)"type", (Object)"FeatureCollection");
        JSONArray newFeatures = new JSONArray();
        newGeoJson.put((Object)"features", (Object)newFeatures);
        for (Map.Entry<ISMLocation, Integer> locMapEntry : locationMap.entrySet()) {
            LocationEntry entry = this.getLocation(locMapEntry.getValue());
            if (entry.getType() != LocationEntry.Type.REGION) continue;
            String regionName = entry.getName();
            region2region.put(regionName, locMapEntry.getKey().getName());
            Integer parentId = entry.getFirstParentId();
            LocationEntry countryEntry = this.getLocation(parentId);
            String countryName = countryEntry.getName();
            ArrayList<String> regions = (ArrayList<String>)countriesWithRegions.get(countryName);
            if (regions == null) {
                regions = new ArrayList<String>();
            }
            regions.add(regionName);
            countriesWithRegions.put(countryName, regions);
        }
        JSONArray featuresArray = (JSONArray)geoJSON.get((Object)"features");
        for (int featIndex = 0; featIndex < featuresArray.size(); ++featIndex) {
            JSONObject featureObj = (JSONObject)featuresArray.get(featIndex);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name = (String)propObj.get((Object)"name");
            if (countriesWithRegions.get(name) == null) {
                newFeatures.add((Object)featureObj);
                continue;
            }
            ArrayList regionNames = (ArrayList)countriesWithRegions.get(name);
            if (regionNames == null || regionNames.isEmpty()) {
                newFeatures.add((Object)featureObj);
                continue;
            }
            List<Integer> countryIds = this.getLocationIds(name);
            LocationEntry countryEntry = this.getLocation(countryIds.get(0));
            String countryGeoJSONStr = countryEntry.getGeoJSON();
            JSONObject countryGeoJSON = null;
            try {
                countryGeoJSON = JSONObject.parse((String)countryGeoJSONStr);
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int regionIndex = 0; regionIndex < regionNames.size(); ++regionIndex) {
                String regionName = null;
                JSONObject regionFeature = new JSONObject();
                JSONObject regionProperties = new JSONObject();
                JSONObject regionGeometry = new JSONObject();
                JSONArray regionCoordinates = new JSONArray();
                regionName = (String)regionNames.get(regionIndex);
                regionProperties.put((Object)"name", region2region.get(regionName));
                regionGeometry.put((Object)"type", (Object)"MultiPolygon");
                regionGeometry.put((Object)"coordinates", (Object)regionCoordinates);
                regionFeature.put((Object)"type", (Object)"Feature");
                regionFeature.put((Object)"properties", (Object)regionProperties);
                regionFeature.put((Object)"geometry", (Object)regionGeometry);
                JSONArray countryFeaturesObjArr = (JSONArray)countryGeoJSON.get((Object)"features");
                for (int countryIndex = 0; countryIndex < countryFeaturesObjArr.size(); ++countryIndex) {
                    JSONObject countryFeatureObj = (JSONObject)countryFeaturesObjArr.get(countryIndex);
                    JSONObject countryPropObj = (JSONObject)countryFeatureObj.get((Object)"properties");
                    String region1 = (String)countryPropObj.get((Object)"region");
                    if (!regionName.equals(region1)) {
                        if (regionIndex != 0 || regionNames.contains(region1)) continue;
                        newFeatures.add((Object)countryFeatureObj);
                        continue;
                    }
                    JSONObject geometryObj = (JSONObject)countryFeatureObj.get((Object)"geometry");
                    JSONArray coordinates = (JSONArray)geometryObj.get((Object)"coordinates");
                    String type = (String)geometryObj.get((Object)"type");
                    if (type.equals("Polygon")) {
                        regionCoordinates.add((Object)coordinates);
                        continue;
                    }
                    if (!type.equals("MultiPolygon")) continue;
                    for (int i = 0; i < coordinates.size(); ++i) {
                        JSONArray multiPoly = (JSONArray)coordinates.get(i);
                        regionCoordinates.add((Object)multiPoly);
                    }
                }
                newFeatures.add((Object)regionFeature);
            }
        }
        return newGeoJson;
    }

    public JSONObject mergePolygons(JSONObject geojson, String groupName, List<Integer> childrenIds, List<DisputedTerritories> dTerritories) {
        JSONArray features = (JSONArray)geojson.get((Object)"features");
        JSONArray newFeatures = new JSONArray();
        boolean found = false;
        JSONObject groupFeature = new JSONObject();
        JSONObject groupProperties = new JSONObject();
        JSONObject groupGeometry = new JSONObject();
        groupProperties.put((Object)"name", (Object)groupName);
        groupFeature.put((Object)"type", (Object)"Feature");
        groupFeature.put((Object)"properties", (Object)groupProperties);
        groupGeometry.put((Object)"type", (Object)"MultiPolygon");
        JSONArray coordinates = new JSONArray();
        ArrayList<String> namesInGroup = new ArrayList<String>();
        for (Integer locId : childrenIds) {
            namesInGroup.add(this.getLocation(locId).getName());
        }
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject propObj = (JSONObject)feature.get((Object)"properties");
            String name = (String)propObj.get((Object)"name");
            if (!namesInGroup.contains(name)) {
                if (groupName.equals("World")) continue;
                newFeatures.add((Object)feature);
                continue;
            }
            found = true;
            JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
            String type = (String)geometry.get((Object)"type");
            if (type.equals("Polygon")) {
                coordinates.add(geometry.get((Object)"coordinates"));
                continue;
            }
            if (type.equals("MultiPolygon")) {
                JSONArray multiPolygon = (JSONArray)geometry.get((Object)"coordinates");
                for (int j = 0; j < multiPolygon.size(); ++j) {
                    JSONArray multiPoly = (JSONArray)multiPolygon.get(j);
                    if (name.equals("Russia") && this.isEastOfDayChangeLine(multiPoly)) continue;
                    coordinates.add((Object)multiPoly);
                }
                continue;
            }
            System.out.println("bad geometry");
        }
        if (found) {
            groupGeometry.put((Object)"coordinates", (Object)coordinates);
            groupFeature.put((Object)"geometry", (Object)groupGeometry);
            newFeatures.add((Object)groupFeature);
            geojson.put((Object)"features", (Object)newFeatures);
        }
        return geojson;
    }

    private boolean isEastOfDayChangeLine(JSONArray multiPoly) {
        JSONArray mp1 = (JSONArray)multiPoly.get(0);
        for (int i = 0; i < multiPoly.size(); ++i) {
            JSONArray mp = (JSONArray)mp1.get(i);
            Double longitude = (Double)mp.get(0);
            if (!(longitude < 0.0)) continue;
            return true;
        }
        return false;
    }

    private JSONObject processUS48or50(JSONObject geoJSON, LocationEntry mapEntry, List<Integer> locIds) {
        if (mapEntry.getType() == LocationEntry.Type.WORLD) {
            return geoJSON;
        }
        String mapName = mapEntry.getName();
        Integer mapParentId = mapEntry.getFirstParentId();
        String mapParentName = this.locationTable.get(mapParentId).getName();
        if (mapName.equals(UNITED_STATES_OF_AMERICA) || mapName.equals("West") && mapParentName.equals(UNITED_STATES_OF_AMERICA)) {
            boolean is50statesMap = false;
            for (Integer locId : locIds) {
                LocationEntry entry = this.locationTable.get(locId);
                String name = entry.getName();
                if (entry.getType() == LocationEntry.Type.COUNTY) {
                    LocationEntry prov = this.getParentOfType(entry, LocationEntry.Type.PROVINCE);
                    name = prov.getName();
                }
                if (name.equals(ALASKA) || name.equals(HAWAII)) {
                    is50statesMap = true;
                }
                if (!name.equals(PUERTO_RICO) && !name.equals(GUAM)) continue;
                is50statesMap = true;
                this.addUSState(geoJSON, entry, mapEntry);
            }
            if (!is50statesMap) {
                geoJSON = this.mapUtilities.removePart(geoJSON, ALASKA);
                geoJSON = this.mapUtilities.removePart(geoJSON, HAWAII);
                geoJSON = this.mapUtilities.removePart(geoJSON, PUERTO_RICO);
                geoJSON = this.mapUtilities.removePart(geoJSON, GUAM);
            } else if (!this.useMapbox) {
                geoJSON = this.mapUtilities.reducePart(geoJSON, ALASKA, 0.4);
                geoJSON = this.mapUtilities.moveUSState(geoJSON, ALASKA, 50, -30);
                geoJSON = this.mapUtilities.moveUSState(geoJSON, HAWAII, 58, 2);
                geoJSON = this.mapUtilities.moveUSState(geoJSON, PUERTO_RICO, -5, 4);
                geoJSON = this.mapUtilities.moveUSState(geoJSON, GUAM, -232, 9);
            }
        }
        return geoJSON;
    }

    public boolean isUSTerritory(String name) {
        String[][] additionalUSTeritories = new String[][]{{PUERTO_RICO, "US-PR", "PR", "P.R."}, {GUAM, "US-GU", "GU"}, {"American Samoa", "US-AS", "AS"}, {"United States Virgin Islands", "U.S. Virgin Islands", "Virgin Islands", "US-VI", "VI"}, {"Federated States of Micronesia", "FM"}, {"Marshall Islands", "MH"}, {"Northern Mariana Islands", "MP"}, {"Palau", "PW"}, {"Armed Forces Europe", "AE"}, {"Armed Forces Pacific", "AP"}, {"Armed Forces Americas", "AA"}};
        for (int i = 0; i < additionalUSTeritories.length; ++i) {
            String[] territory = additionalUSTeritories[i];
            if (name.toLowerCase().equals(territory[0].toLowerCase())) {
                return true;
            }
            for (int j = 1; j < territory.length; ++j) {
                if (!name.toLowerCase().equals(territory[j].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNonCountry(String name) {
        String[][] nonCountries = new String[][]{{"England"}, {"Scotland"}, {"Wales"}, {"Northern Ireland"}, {TAIWAN, "TW", "TWN", "Chinese Taipei"}, {"Macao", "MO", "Macao", "MAC"}, {"Hong Kong", "HK", "HKG", "H.K."}, {"French Guyana"}, {"Tahiti"}, {"Guadeloupe"}, {"Palestine"}, {"Micronesia"}, {"Martinique"}};
        for (int i = 0; i < nonCountries.length; ++i) {
            String[] territory = nonCountries[i];
            if (name.toLowerCase().equals(territory[0].toLowerCase())) {
                return true;
            }
            for (int j = 1; j < territory.length; ++j) {
                if (!name.toLowerCase().equals(territory[j].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public Integer getUSStateId(String name) {
        Integer usId = this.getLocationIds(UNITED_STATES_OF_AMERICA).get(0);
        List<Integer> locIds = this.getLocationIds(new SMLocation(name), LocationEntry.Type.PROVINCE);
        for (Integer locId : locIds) {
            if (!this.isGrandParent(usId, locId) && !this.isParent(usId, locId)) continue;
            return locId;
        }
        return -1;
    }

    public JSONObject containsUSStatesAndTerritoriesOnly(Set<ISMLocation> iLocations) {
        JSONObject result = new JSONObject();
        boolean hasUSStates = false;
        boolean hasUSTerritories = false;
        for (ISMLocation iLocation : iLocations) {
            List<Integer> locIds;
            String name = iLocation.getName();
            Integer id = this.getUSStateId(name);
            if (id != -1) {
                hasUSStates = true;
                if (!this.ambiguityHandler.isAmbiguous(name)) continue;
                result.put((Object)name, (Object)id);
                continue;
            }
            if (this.isUSTerritory(name)) {
                hasUSTerritories = true;
                locIds = this.getLocationIds(iLocation);
                if (locIds == null) {
                    result.put((Object)name, (Object)999999);
                    continue;
                }
                result.put((Object)name, (Object)locIds.get(0));
                continue;
            }
            locIds = this.getLocationIds(iLocation);
            if (locIds == null || locIds.size() <= 0) continue;
            return null;
        }
        if (hasUSStates && hasUSTerritories) {
            return result;
        }
        return null;
    }

    public JSONObject containsExtendedCountries(Set<ISMLocation> iLocations) {
        JSONObject result = new JSONObject();
        boolean hasCountries = false;
        boolean hasNonCountries = false;
        for (ISMLocation iLocation : iLocations) {
            String name = iLocation.getName();
            List<Integer> ids = this.getLocationIds(iLocation, LocationEntry.Type.COUNTRY);
            if (!ids.isEmpty()) {
                hasCountries = true;
                if (!this.ambiguityHandler.isAmbiguous(name)) continue;
                result.put((Object)name, (Object)ids.get(0));
                continue;
            }
            if (this.isNonCountry(name)) {
                hasNonCountries = true;
                if (!this.ambiguityHandler.isAmbiguous(name)) continue;
                ids = this.getLocationIds(name);
                result.put((Object)name, (Object)ids.get(0));
                continue;
            }
            return null;
        }
        if (hasCountries && hasNonCountries) {
            return result;
        }
        return null;
    }

    private void addUSState(JSONObject geoJSON, LocationEntry movedEntry, LocationEntry newParentEntry) {
        List<Integer> locIds = this.getLocationIds(movedEntry.getName());
        Integer countryId = locIds.get(0);
        LocationEntry countryEntry = this.getLocation(countryId);
        String geoJSONStr = countryEntry.getGeoJSON();
        JSONObject countryGeoJSON = null;
        try {
            countryGeoJSON = (JSONObject)JSON.parse((String)geoJSONStr);
        }
        catch (Exception e) {
            return;
        }
        JSONArray countryFeatures = (JSONArray)countryGeoJSON.get((Object)"features");
        JSONObject movedFeature = (JSONObject)countryFeatures.get(0);
        if (movedFeature == null) {
            return;
        }
        JSONObject propObj = (JSONObject)movedFeature.get((Object)"properties");
        propObj.put((Object)"ADMIN", (Object)UNITED_STATES_OF_AMERICA);
        JSONArray features = (JSONArray)geoJSON.get((Object)"features");
        features.add((Object)movedFeature);
    }

    private JSONObject resolveHierarchy(JSONObject geoJSON, LocationEntry ancestor, List<Integer> locIds) throws IOException {
        if (ancestor.getType() == LocationEntry.Type.SUBREGION || ancestor.getType() == LocationEntry.Type.CONTINENT || ancestor.getType() == LocationEntry.Type.WORLD) {
            LocationEntry element;
            HashSet<Integer> provincesMapIds = new HashSet<Integer>();
            for (Integer locId : locIds) {
                element = this.locationTable.get(locId);
                if (element == null) {
                    System.out.println();
                }
                if (element.getType() != LocationEntry.Type.PROVINCE) continue;
                Integer parentId = element.getFirstParentId();
                element = this.locationTable.get(parentId);
                while (element.getType() != LocationEntry.Type.COUNTRY) {
                    parentId = element.getFirstParentId();
                    element = this.locationTable.get(parentId);
                }
                if (locIds.contains(parentId)) continue;
                provincesMapIds.add(parentId);
            }
            if (provincesMapIds.size() > 0) {
                for (Integer locId : provincesMapIds) {
                    element = this.locationTable.get(locId);
                    JSONArray features = (JSONArray)geoJSON.get((Object)"features");
                    JSONArray newFeatures = new JSONArray();
                    for (int i = 0; i < features.size(); ++i) {
                        JSONObject feature = (JSONObject)features.get(i);
                        JSONObject properties = (JSONObject)feature.get((Object)"properties");
                        if (properties.get((Object)"name").equals(element.getName())) continue;
                        newFeatures.add((Object)feature);
                    }
                    geoJSON.put((Object)"features", (Object)newFeatures);
                    String provinceGeoJSONString = element.getGeoJSON();
                    JSONObject provinceGeoJSON = JSONObject.parse((String)provinceGeoJSONString);
                    geoJSON = this.addGeoJSON(geoJSON, provinceGeoJSON);
                }
            }
        }
        return geoJSON;
    }

    public boolean equalsNameOrAlias(String name1, LocationEntry entry) {
        return this.equalsNormalized(name1, entry.getName()) || this.containsNormalized(entry.getAliases(), name1);
    }

    private String getGeoJSON(LocationEntry locationEntry) {
        String geoJSONString = locationEntry.getGeoJSON();
        if (geoJSONString.equals("children")) {
            JSONObject geoJSON = new JSONObject();
            List<Integer> children = locationEntry.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                LocationEntry child = this.locationTable.get(children.get(i));
                try {
                    geoJSON = this.addGeoJSON(geoJSON, JSONObject.parse((String)this.getGeoJSON(child)));
                    continue;
                }
                catch (IOException e) {
                    return null;
                }
            }
            geoJSONString = geoJSON.toString();
        } else {
            if (locationEntry.getType() == LocationEntry.Type.GROUP) {
                Integer parentLoc = locationEntry.getFirstParentId();
                String parentMap = this.getGeoJSON(this.locationTable.get(parentLoc));
                List<Integer> children = locationEntry.getChildren();
                ArrayList<String> mapElem = new ArrayList<String>();
                for (Integer c : children) {
                    mapElem.add(this.locationTable.get(c).getName());
                }
                return this.getReducedMap(parentMap, mapElem);
            }
            if (geoJSONString.equals("parent")) {
                Integer parentLoc = locationEntry.getFirstParentId();
                String parentMap = this.getGeoJSON(this.locationTable.get(parentLoc));
                ArrayList<String> mapElem = new ArrayList<String>();
                mapElem.add(locationEntry.getName());
                return this.getReducedMap(parentMap, mapElem);
            }
        }
        return geoJSONString;
    }

    private String getReducedMap(String parentMap, List<String> mapElem) {
        JSONObject geoJSON = null;
        try {
            geoJSON = JSONObject.parse((String)parentMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        JSONArray features = (JSONArray)geoJSON.get((Object)"features");
        JSONArray newFeatures = new JSONArray();
        geoJSON.put((Object)"features", (Object)newFeatures);
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject prop = (JSONObject)feature.get((Object)"properties");
            String sName = (String)prop.get((Object)"region");
            if (sName == null || !this.containsNormalized(mapElem, sName)) continue;
            newFeatures.add((Object)feature);
            geoJSON.put((Object)"features", (Object)newFeatures);
        }
        return geoJSON.toString();
    }

    private JSONObject addGeoJSON(JSONObject geoJson1, JSONObject geoJson2) {
        if (geoJson1.isEmpty()) {
            return geoJson2;
        }
        JSONArray featuresObjArr = (JSONArray)geoJson1.get((Object)"features");
        JSONArray featuresObjArr1 = (JSONArray)geoJson2.get((Object)"features");
        if (featuresObjArr1 == null) {
            System.out.println("NULL featuresObjArr1");
        }
        featuresObjArr.addAll((Collection)featuresObjArr1);
        return geoJson1;
    }

    private List<Integer> getCommonPath(List<Integer> path1, List<Integer> path2) {
        Integer p2;
        Integer p1;
        int count = path1.size();
        if (path2.size() < count) {
            count = path2.size();
        }
        ArrayList<Integer> commonPath = new ArrayList<Integer>();
        commonPath.add(path1.get(0));
        for (int i = 1; i < count && (p1 = path1.get(i)).equals(p2 = path2.get(i)); ++i) {
            commonPath.add(path1.get(i));
        }
        return commonPath;
    }

    public List<Integer> getPathToRoot(Integer locationId, List<DisputedTerritories> dTerritories) {
        Integer parentId = this.getParentIdWithDisputedTerritories(locationId, dTerritories);
        LocationEntry node = null;
        ArrayList<Integer> path = new ArrayList<Integer>();
        if (parentId == null) {
            LocationEntry locId = this.getLocation(locationId);
            if (locId == null) {
                return path;
            }
            parentId = locId.getFirstParentId();
        }
        if (parentId == null) {
            return path;
        }
        node = this.locationTable.get(parentId);
        if (node == null) {
            return path;
        }
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(parentId);
        while (node.getParents().size() > 0) {
            Integer parent = node.getFirstParentId();
            stack.push(parent);
            node = this.locationTable.get(parent);
        }
        while (!stack.isEmpty()) {
            path.add((Integer)stack.pop());
        }
        path.add(locationId);
        return path;
    }

    public JSONObject addAlias(String inputLocation, String alias) {
        JSONObject result = new JSONObject();
        if (inputLocation == null || inputLocation.isEmpty()) {
            result.put((Object)"null or empty name", (Object)inputLocation);
            return result;
        }
        List<Integer> locIds = null;
        String[] parts = inputLocation.split("/");
        if (parts.length == 1) {
            locIds = this.getLocationIds(parts[0]);
        } else {
            String name = parts[0];
            ArrayList<ISMLocation> ancestors = new ArrayList<ISMLocation>();
            String ancestor = parts[1];
            ancestors.add(new SMLocation(ancestor));
            SMLocation iSMLocation = new SMLocation(name, ancestors);
            locIds = this.getLocationIds(iSMLocation);
        }
        if (locIds == null || locIds.size() == 0) {
            result.put((Object)"name not found", (Object)inputLocation);
            return result;
        }
        if (locIds.size() > 1) {
            result.put((Object)"ambiguous name", (Object)inputLocation);
        } else {
            int locId = locIds.get(0);
            LocationEntry entry = this.locationTable.get(locId);
            entry.addAlias(alias);
            this.locationTableHandler.addToLocationTable(locId, entry);
        }
        return result;
    }

    private boolean equalsNormalized(String name, String name2) {
        return this.locationTableHandler.equalsNormalized(name, name2);
    }

    public String normalize(String name) {
        return this.locationTableHandler.normalize(name);
    }

    public String replaceSpecialChars(String inputName) {
        String newName = Normalizer.normalize(inputName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        return newName;
    }

    private boolean containsNormalized(List<String> iLocations, String name) {
        String normalizedName = this.normalize(name);
        for (String nameInList : iLocations) {
            String normalizedNameInList = this.normalize(nameInList);
            if (!normalizedNameInList.equals(normalizedName)) continue;
            return true;
        }
        return false;
    }

    public LocationEntry getParentOfType(LocationEntry entry, LocationEntry.Type type1) {
        LocationEntry parent = null;
        Integer parentId = -1;
        LocationEntry.Type type = null;
        do {
            if ((type = (parent = this.getLocation(parentId = entry.getFirstParentId())).getType()) == LocationEntry.Type.WORLD) {
                return null;
            }
            entry = parent;
        } while (type != type1);
        return parent;
    }

    public Integer getLocationId(String locationName, String parentName) {
        List<Integer> locIds = this.getLocationIds(locationName);
        if (locIds != null) {
            ArrayList<Integer> parentIds = new ArrayList<Integer>();
            for (int i = 0; i < locIds.size(); ++i) {
                Integer locId = locIds.get(i);
                LocationEntry entry = this.getLocation(locId);
                Integer pid = entry.getFirstParentId();
                LocationEntry parentEntry = this.getLocation(pid);
                if (!parentEntry.getName().equals(parentName)) continue;
                parentIds.add(locId);
            }
            if (parentIds.size() == 1) {
                return (Integer)parentIds.get(0);
            }
            if (parentIds.size() > 1) {
                System.out.println("not unique " + parentName + "=" + parentIds);
            }
        }
        return null;
    }

    public List<Integer> getLocationIds(ISMLocation iLocation) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<Integer> locIdsForName = this.getLocationIds(iLocation.getName());
        if (locIdsForName == null) {
            return null;
        }
        if (locIdsForName.size() == 1) {
            return locIdsForName;
        }
        String ancestorName = iLocation.getParentName();
        if (ancestorName == null) {
            return locIdsForName;
        }
        List<Integer> locIdsForAncestor = this.getLocationIds(ancestorName);
        if (locIdsForAncestor == null) {
            return locIdsForName;
        }
        for (Integer idName : locIdsForName) {
            for (Integer idAncestor : locIdsForAncestor) {
                if (!this.isAncestor(idAncestor, idName, null)) continue;
                result.add(idName);
            }
        }
        if (result.isEmpty()) {
            return locIdsForName;
        }
        return result;
    }

    private Integer getLocationId(String locationName, String parentName, LocationEntry.Type type) {
        List<Integer> locIds = this.getLocationIds(locationName);
        for (int i = 0; i < locIds.size(); ++i) {
            LocationEntry parentEntry;
            LocationEntry entry = this.getLocation(locIds.get(i));
            if (type != null && entry.getType() != type || entry.getType() == LocationEntry.Type.CITY || !parentName.equals((parentEntry = this.getLocation(entry.getFirstParentId())).getName())) continue;
            return locIds.get(i);
        }
        return null;
    }

    public boolean isGenericRegion(List<ISMLocation> locations) {
        if (locations == null || locations.isEmpty()) {
            return false;
        }
        String[] genericRegions = new String[]{"north", "south", "east", "west", "central", "north east", "north west", "south east", "south west", "northeast", "northwest", "southeast", "southwest", "eastern", "northern", "western", "southern"};
        int threshold = 80;
        List<String> list = Arrays.asList(genericRegions);
        int found = 0;
        for (ISMLocation loc : locations) {
            if (!list.contains(loc.getName().toLowerCase())) continue;
            ++found;
        }
        return found * 100 / locations.size() >= threshold;
    }

    public boolean isInACountry(Integer locId) {
        LocationEntry.Type type = this.getLocation(locId).getType();
        return type != LocationEntry.Type.WORLD && type != LocationEntry.Type.CONTINENT && type != LocationEntry.Type.SUBREGION && type != LocationEntry.Type.COUNTRY;
    }

    public List<Integer> getLocationIdsWithAncestor(String name, String ancestor) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<Integer> ancestorIds = this.getLocationIds(ancestor);
        List<Integer> nameIds = this.getLocationIds(name);
        if (ancestorIds == null || ancestorIds.size() == 0 || nameIds == null || nameIds.size() == 0) {
            return null;
        }
        for (int i = 0; i < ancestorIds.size(); ++i) {
            for (int j = 0; j < nameIds.size(); ++j) {
                Integer id;
                if (!this.isAncestor(ancestorIds.get(i), nameIds.get(j), null) || ids.contains(id = nameIds.get(j))) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    public void addCustomerAliases() {
        InputStream inputStream = LocationIndexer.class.getResourceAsStream(CUSTOMER_ALIASES_RESOURCE);
        String fileContent = this.locationTableHandler.readFile(inputStream);
        if (fileContent == null) {
            return;
        }
        String[] lines = fileContent.split("\n");
        String line = "";
        for (int i = 0; i < lines.length; ++i) {
            String[] names;
            line = lines[i].trim();
            if (line.startsWith("//") || line.isEmpty() || (names = line.split(",")).length < 2) continue;
            String name = names[0];
            String alias = "";
            for (int j = 1; j < names.length; ++j) {
                alias = names[j];
                this.addAlias(name, alias.trim());
            }
        }
    }

    public void setUseMapbox(boolean value) {
        this.useMapbox = value;
    }

    public static enum DisputedTerritories {
        ChinaPrecedence,
        TaiwanPrecedence,
        IndiaPrecedence,
        PakistanPrecedence,
        IsraelPrecedence,
        WestBankPrecedence;

    }
}

