/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.model.AmbiguityHandlerPB;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationTableHandlerPB;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class LocationIndexerPB {
    private static final LocationIndexerPB INSTANCE = new LocationIndexerPB();
    public static final String UNITED_STATES_OF_AMERICA = "United States of America";
    private Map<Integer, LocationEntry> locationTable = null;
    private AmbiguityHandlerPB ambiguityHandler = new AmbiguityHandlerPB();
    private LocationTableHandlerPB locationTableHandler = null;

    private LocationIndexerPB() {
        this.ambiguityHandler.setIndexer(this);
        this.locationTableHandler = new LocationTableHandlerPB();
        try {
            this.locationTable = this.locationTableHandler.getLocationTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LocationIndexerPB getInstance() {
        return INSTANCE;
    }

    public LocationEntry getLocation(Integer locationId) {
        return this.locationTable.get(locationId);
    }

    public List<Integer> getLocationIdsForName(String name) {
        if (name == null) {
            return null;
        }
        List<Integer> ids = this.locationTableHandler.getAllLocationIds(name);
        ArrayList<Integer> ids1 = new ArrayList<Integer>();
        if (ids == null) {
            return null;
        }
        for (Integer id : ids) {
            LocationEntry entry = this.getLocation(id);
            if (entry.getMapId().isEmpty()) continue;
            ids1.add(id);
        }
        if (ids.isEmpty()) {
            return null;
        }
        return ids1;
    }

    public List<Integer> getLocationIds(ISMLocation iLocation, String type) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<Integer> allIds = this.getLocationIds(iLocation);
        if (allIds == null) {
            return ids;
        }
        for (Integer id : allIds) {
            String mapid = this.getLocation(id).getMapId();
            if (type != null && (!mapid.equals(type) || ids.contains(id))) continue;
            ids.add(id);
        }
        return ids;
    }

    private Integer getNearestCommonAncestorId(List<Integer> locIds) {
        if (locIds == null || locIds.size() < 1) {
            return null;
        }
        if (locIds.size() == 1) {
            return (Integer)locIds.toArray()[0];
        }
        List<Integer> path = null;
        Integer first = null;
        for (Integer locId : locIds) {
            if (locId == null) continue;
            if (first == null) {
                first = locId;
                path = this.getPathToRoot(locId);
                continue;
            }
            List<Integer> path1 = this.getPathToRoot(locId);
            if (path.isEmpty() && path1.isEmpty()) {
                return null;
            }
            path = this.getCommonPath(path, path1);
        }
        if (path == null) {
            return null;
        }
        int size = path.size() - 1;
        return (Integer)path.get(size);
    }

    public boolean isAncestor(Integer smallestAncestorId, Integer locId) {
        if (smallestAncestorId == locId) {
            return false;
        }
        String ancestorName = this.getLocation(smallestAncestorId).getName();
        if (ancestorName.equals(UNITED_STATES_OF_AMERICA)) {
            LocationEntry entry = this.getLocation(locId);
            String locationName = entry.getName();
            if (entry.getType() == LocationEntry.Type.COUNTRY && this.isUSTerritory(locationName)) {
                return true;
            }
        }
        List<Integer> path = this.getPathToRoot(locId);
        return path.contains(smallestAncestorId);
    }

    public boolean isAncestor(String ancestor, String name) {
        List<Integer> ancestorIds = this.getLocationIdsForName(ancestor);
        List<Integer> nameIds = this.getLocationIdsForName(name);
        if (ancestorIds == null || ancestorIds.size() == 0 || nameIds == null || nameIds.size() == 0) {
            return false;
        }
        for (int i = 0; i < ancestorIds.size(); ++i) {
            for (int j = 0; j < nameIds.size(); ++j) {
                if (!this.isAncestor(ancestorIds.get(i), nameIds.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized JSONObject getMap(Map<ISMLocation, Integer> locationMap) {
        ArrayList<Integer> locIds;
        JSONObject map = new JSONObject();
        if (locationMap.isEmpty()) {
            return map;
        }
        Integer ancestorId = null;
        JSONObject statesAndTerritories = this.containsUSStatesAndTerritoriesOnly(locationMap.keySet());
        boolean mapCompleted = true;
        for (Map.Entry<ISMLocation, Integer> entry : locationMap.entrySet()) {
            if (entry.getValue() != null) continue;
            mapCompleted = false;
            break;
        }
        if (mapCompleted && statesAndTerritories == null) {
            ArrayList<Integer> locIds2 = new ArrayList<Integer>();
            locIds2.addAll(locationMap.values());
        } else {
            Integer id;
            String name;
            JSONObject extendedCountries = this.containsExtendedCountries(locationMap.keySet());
            locIds = new ArrayList<Integer>();
            for (Integer locId : locationMap.values()) {
                if (locId == null) continue;
                locIds.add(locId);
            }
            if (statesAndTerritories != null) {
                for (ISMLocation key : locationMap.keySet()) {
                    name = key.getName();
                    id = (Integer)statesAndTerritories.get((Object)name);
                    if (id == null) continue;
                    locationMap.put(key, id);
                }
                ancestorId = this.getLocationIdsForName(UNITED_STATES_OF_AMERICA).get(0);
            } else if (extendedCountries != null) {
                for (ISMLocation key : locationMap.keySet()) {
                    name = key.getName();
                    id = (Integer)extendedCountries.get((Object)name);
                    if (extendedCountries.get((Object)name) == null) continue;
                    locIds.add(id);
                    locationMap.put(key, id);
                }
                ancestorId = this.getNearestCommonAncestorId(locIds);
            } else {
                ancestorId = this.getNearestCommonAncestorIdForLocations(locationMap.keySet());
                JSONObject ambiguityResult = this.ambiguityHandler.processAmbiguousList(locationMap.keySet(), ancestorId);
                JSONObject resolvedIds = (JSONObject)ambiguityResult.get((Object)"resolvedIds");
                if (resolvedIds == null) {
                    map = ambiguityResult;
                } else {
                    JSONArray ambiguous = (JSONArray)ambiguityResult.get((Object)"ambiguous");
                    if (ambiguous != null) {
                        map.put((Object)"ambiguous", (Object)ambiguous);
                    }
                }
                for (ISMLocation key : locationMap.keySet()) {
                    Integer id2;
                    if (locationMap.get(key) != null || resolvedIds == null || (id2 = (Integer)resolvedIds.get((Object)key.toString())) == null) continue;
                    locationMap.put(key, id2);
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.addAll(locationMap.values());
                ancestorId = this.getNearestCommonAncestorId(list);
            }
        }
        ArrayList<String> locationNames = new ArrayList<String>();
        for (ISMLocation key : locationMap.keySet()) {
            locationNames.add(this.normalize(key.getName()));
        }
        locIds = new ArrayList();
        locIds.addAll(locationMap.values());
        JSONArray ids = new JSONArray();
        for (Integer id : locIds) {
            if (id == null) continue;
            ids.add((Object)id);
        }
        map.put((Object)"ids", (Object)ids);
        return map;
    }

    public Integer getNearestCommonAncestorIdForLocations(Set<ISMLocation> iLocations) {
        if (iLocations == null || iLocations.size() < 1) {
            return null;
        }
        if (iLocations.size() == 1) {
            ISMLocation iLocation = (ISMLocation)iLocations.toArray()[0];
            List<Integer> locIds = this.getLocationIds(iLocation);
            if (locIds == null || locIds.isEmpty()) {
                return null;
            }
            return locIds.get(0);
        }
        int ind = this.getCommonParent(iLocations);
        if (ind > 0) {
            return ind;
        }
        ind = this.getCommonGrandParent(iLocations);
        if (ind > 0) {
            return ind;
        }
        int len = iLocations.size();
        int ind1 = 0;
        int ind2 = 1;
        ISMLocation iLocation1 = (ISMLocation)iLocations.toArray()[ind1];
        List<Integer> ids1 = this.getLocationIds(iLocation1);
        if (ids1 == null) {
            return 1;
        }
        ISMLocation iLocation2 = (ISMLocation)iLocations.toArray()[ind2];
        List<Integer> ids2 = this.getLocationIds(iLocation2);
        if (ids2 == null) {
            return 1;
        }
        List<Object> maxPath = new ArrayList();
        for (Integer id1 : ids1) {
            List<Integer> path1 = this.getPathToRoot(id1);
            for (Integer id2 : ids2) {
                List<Integer> path2 = this.getPathToRoot(id2);
                if (path1.containsAll(path2)) {
                    maxPath = path1;
                    continue;
                }
                if (path2.containsAll(path1)) {
                    maxPath = path2;
                    continue;
                }
                List<Integer> commonPath = this.getCommonPath(path1, path2);
                if (maxPath.size() >= commonPath.size()) continue;
                maxPath.clear();
                maxPath.addAll(commonPath);
                if (maxPath.size() != 1) continue;
                return 1;
            }
        }
        ++ind2;
        while (ind2 < len) {
            iLocation2 = (ISMLocation)iLocations.toArray()[ind2];
            ids2 = this.getLocationIds(iLocation2);
            if (ids2 == null) {
                return 1;
            }
            ArrayList<Integer> maxPath1 = new ArrayList<Integer>();
            for (Integer id2 : ids2) {
                List<Integer> path2 = this.getPathToRoot(id2);
                if (path2.isEmpty()) continue;
                List<Integer> commonPath = this.getCommonPath(maxPath, path2);
                if (maxPath1.size() >= commonPath.size()) continue;
                maxPath1.clear();
                maxPath1.addAll(commonPath);
            }
            maxPath.clear();
            maxPath.addAll(maxPath1);
            if (maxPath.size() == 1) {
                return 1;
            }
            ++ind2;
        }
        int size = maxPath.size() - 1;
        Integer root = 0;
        root = size <= 0 ? Integer.valueOf(1) : (Integer)maxPath.get(size);
        return root;
    }

    public Integer getCommonParent(Set<ISMLocation> iLocations) {
        ISMLocation iLocation = (ISMLocation)iLocations.toArray()[0];
        Set<Integer> parentIds = this.getParentIds(iLocation);
        for (int i = 1; i < iLocations.size(); ++i) {
            iLocation = (ISMLocation)iLocations.toArray()[i];
            Set<Integer> pIds = this.getParentIds(iLocation);
            parentIds.retainAll(pIds);
            if (!parentIds.isEmpty()) continue;
            return 0;
        }
        return (Integer)parentIds.toArray()[0];
    }

    public Integer getCommonGrandParent(Set<ISMLocation> iLocations) {
        LocationEntry entry;
        ISMLocation iLocation = (ISMLocation)iLocations.toArray()[0];
        Set<Integer> parentIds = this.getParentIds(iLocation);
        HashSet<Integer> grandParentIds = new HashSet<Integer>();
        Iterator<Integer> itr = parentIds.iterator();
        while (itr.hasNext()) {
            entry = this.getLocation(itr.next());
            grandParentIds.addAll(entry.getParents());
        }
        for (int i = 1; i < iLocations.size(); ++i) {
            iLocation = (ISMLocation)iLocations.toArray()[i];
            parentIds = this.getParentIds(iLocation);
            HashSet<Integer> gpIds = new HashSet<Integer>();
            itr = parentIds.iterator();
            while (itr.hasNext()) {
                entry = this.getLocation(itr.next());
                gpIds.addAll(entry.getParents());
            }
            grandParentIds.retainAll(gpIds);
            if (!grandParentIds.isEmpty()) continue;
            return 0;
        }
        return (Integer)grandParentIds.toArray()[0];
    }

    private Set<Integer> getParentIds(ISMLocation iLocation) {
        HashSet<Integer> result = new HashSet<Integer>();
        List<Integer> ids = this.getLocationIds(iLocation);
        if (ids == null) {
            return result;
        }
        for (int i = 0; i < ids.size(); ++i) {
            LocationEntry id = this.getLocation(ids.get(i));
            result.addAll(id.getParents());
        }
        return result;
    }

    public boolean isParent(Integer parentId, Integer childId) {
        LocationEntry entry = this.getLocation(parentId);
        if (entry == null || entry.getChildren() == null) {
            return false;
        }
        return entry.getChildren().contains(childId);
    }

    public boolean isGrandParent(Integer parentId, Integer childId) {
        LocationEntry entry = this.getLocation(parentId);
        for (Integer id : entry.getChildren()) {
            if (!this.isParent(id, childId)) continue;
            return true;
        }
        return false;
    }

    public boolean isUSTerritory(String name) {
        String[][] additionalUSTeritories = new String[][]{{"Puerto Rico", "US-PR", "PR", "P.R."}, {"Guam", "US-GU", "GU"}, {"American Samoa", "US-AS", "AS"}, {"United States Virgin Islands", "U.S. Virgin Islands", "Virgin Islands", "US-VI", "VI"}, {"Federated States of Micronesia", "FM"}, {"Marshall Islands", "MH"}, {"Northern Mariana Islands", "MP"}, {"Palau", "PW"}, {"Armed Forces Europe", "AE"}, {"Armed Forces Pacific", "AP"}, {"Armed Forces Americas", "AA"}};
        for (int i = 0; i < additionalUSTeritories.length; ++i) {
            String[] territory = additionalUSTeritories[i];
            if (name.toLowerCase().equals(territory[0].toLowerCase())) {
                return true;
            }
            for (int j = 1; j < territory.length; ++j) {
                if (!name.toLowerCase().equals(territory[j].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNonCountry(String name) {
        String[][] nonCountries = new String[][]{{"England"}, {"Scotland"}, {"Wales"}, {"Northern Ireland"}, {"Taiwan", "TW", "TWN", "Chinese Taipei"}, {"Macao", "MO", "Macao", "MAC"}, {"Hong Kong", "HK", "HKG", "H.K."}, {"French Guyana"}, {"Tahiti"}, {"Guadeloupe"}, {"Palestine"}, {"Micronesia"}, {"Martinique"}};
        for (int i = 0; i < nonCountries.length; ++i) {
            String[] territory = nonCountries[i];
            if (name.toLowerCase().equals(territory[0].toLowerCase())) {
                return true;
            }
            for (int j = 1; j < territory.length; ++j) {
                if (!name.toLowerCase().equals(territory[j].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public Integer getUSStateId(String name) {
        Integer usId = this.getLocationIdsForName(UNITED_STATES_OF_AMERICA).get(0);
        List<Integer> locIds = this.getLocationIds(new SMLocation(name), "a1");
        for (Integer locId : locIds) {
            if (!this.isGrandParent(usId, locId) && !this.isParent(usId, locId)) continue;
            return locId;
        }
        return -1;
    }

    public JSONObject containsUSStatesAndTerritoriesOnly(Set<ISMLocation> iLocations) {
        JSONObject result = new JSONObject();
        boolean hasUSStates = false;
        boolean hasUSTerritories = false;
        for (ISMLocation iLocation : iLocations) {
            List<Integer> locIds;
            String name = iLocation.getName();
            Integer id = this.getUSStateId(name);
            if (id != -1) {
                hasUSStates = true;
                if (!this.ambiguityHandler.isAmbiguous(name)) continue;
                result.put((Object)name, (Object)id);
                continue;
            }
            if (this.isUSTerritory(name)) {
                hasUSTerritories = true;
                locIds = this.getLocationIds(iLocation);
                if (locIds == null) {
                    result.put((Object)name, (Object)999999);
                    continue;
                }
                result.put((Object)name, (Object)locIds.get(0));
                continue;
            }
            locIds = this.getLocationIds(iLocation);
            if (locIds == null || locIds.size() <= 0) continue;
            return null;
        }
        if (hasUSStates && hasUSTerritories) {
            return result;
        }
        return null;
    }

    public JSONObject containsExtendedCountries(Set<ISMLocation> iLocations) {
        JSONObject result = new JSONObject();
        boolean hasCountries = false;
        boolean hasNonCountries = false;
        for (ISMLocation iLocation : iLocations) {
            String name = iLocation.getName();
            List<Integer> ids = this.getLocationIds(iLocation, "n");
            if (!ids.isEmpty()) {
                hasCountries = true;
                if (!this.ambiguityHandler.isAmbiguous(name)) continue;
                result.put((Object)name, (Object)ids.get(0));
                continue;
            }
            if (this.isNonCountry(name)) {
                hasNonCountries = true;
                ids = this.getLocationIds(iLocation, "a1");
                if (ids.isEmpty()) {
                    ids = this.getLocationIds(iLocation, "a2");
                }
                if (ids.isEmpty()) continue;
                result.put((Object)name, (Object)ids.get(0));
                continue;
            }
            return null;
        }
        if (hasCountries && hasNonCountries) {
            return result;
        }
        return null;
    }

    public boolean equalsNameOrAlias(String name, LocationEntry entry) {
        return this.equalsNormalized(name, entry.getName()) || this.containsNormalized(entry.getAliases(), name);
    }

    private List<Integer> getCommonPath(List<Integer> path1, List<Integer> path2) {
        Integer p2;
        Integer p1;
        int count = path1.size();
        if (path2.size() < count) {
            count = path2.size();
        }
        ArrayList<Integer> commonPath = new ArrayList<Integer>();
        commonPath.add(path1.get(0));
        for (int i = 1; i < count && (p1 = path1.get(i)).equals(p2 = path2.get(i)); ++i) {
            commonPath.add(path1.get(i));
        }
        return commonPath;
    }

    public List<Integer> getPathToRoot(Integer locationId) {
        Integer parentId = null;
        LocationEntry node = null;
        ArrayList<Integer> path = new ArrayList<Integer>();
        if (parentId == null) {
            LocationEntry locId = this.getLocation(locationId);
            if (locId == null) {
                return path;
            }
            parentId = locId.getFirstParentId();
        }
        if (parentId == null) {
            return path;
        }
        node = this.locationTable.get(parentId);
        if (node == null) {
            return path;
        }
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(parentId);
        while (node.getParents().size() > 0) {
            Integer parent = node.getFirstParentId();
            stack.push(parent);
            node = this.locationTable.get(parent);
        }
        while (!stack.isEmpty()) {
            path.add((Integer)stack.pop());
        }
        path.add(locationId);
        return path;
    }

    private boolean equalsNormalized(String name, String name2) {
        return this.locationTableHandler.equalsNormalized(name, name2);
    }

    public String normalize(String name) {
        return this.locationTableHandler.normalize(name);
    }

    public String replaceSpecialChars(String inputName) {
        String newName = Normalizer.normalize(inputName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        return newName;
    }

    private boolean containsNormalized(List<String> iLocations, String name) {
        String normalizedName = this.normalize(name);
        for (String nameInList : iLocations) {
            String normalizedNameInList = this.normalize(nameInList);
            if (!normalizedNameInList.equals(normalizedName)) continue;
            return true;
        }
        return false;
    }

    public LocationEntry getParentOfType(LocationEntry entry, LocationEntry.Type type1) {
        LocationEntry parent = null;
        Integer parentId = -1;
        LocationEntry.Type type = null;
        do {
            if ((type = (parent = this.getLocation(parentId = entry.getFirstParentId())).getType()) == LocationEntry.Type.WORLD) {
                return null;
            }
            entry = parent;
        } while (type != type1);
        return parent;
    }

    public Integer getLocationId(String locationName, String parentName) {
        List<Integer> locIds = this.getLocationIdsForName(locationName);
        if (locIds != null) {
            ArrayList<Integer> parentIds = new ArrayList<Integer>();
            for (int i = 0; i < locIds.size(); ++i) {
                Integer locId = locIds.get(i);
                LocationEntry entry = this.getLocation(locId);
                Integer pid = entry.getFirstParentId();
                LocationEntry parentEntry = this.getLocation(pid);
                if (!parentEntry.getName().equals(parentName)) continue;
                parentIds.add(locId);
            }
            if (parentIds.size() == 1) {
                return (Integer)parentIds.get(0);
            }
            if (parentIds.size() > 1) {
                System.out.println("not unique " + parentName + "=" + parentIds);
            }
        }
        return null;
    }

    public List<Integer> getLocationIds(ISMLocation iLocation) {
        if (iLocation == null) {
            return null;
        }
        List<Integer> locIdsForName = this.getLocationIdsForName(iLocation.getName());
        LocationEntry entry = null;
        if (locIdsForName == null) {
            return null;
        }
        ArrayList<Integer> locIdsForNameNonPostal = new ArrayList<Integer>();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer locIdForName : locIdsForName) {
            entry = this.getLocation(locIdForName);
            if (entry.getMapId().startsWith("p")) continue;
            locIdsForNameNonPostal.add(locIdForName);
        }
        if (locIdsForNameNonPostal.isEmpty()) {
            return null;
        }
        List<Integer> path = null;
        String name = "";
        Integer locId = -1;
        List<ISMLocation> ancestryLocations = iLocation.getAncestryLocations();
        if (ancestryLocations == null || ancestryLocations.isEmpty()) {
            return locIdsForNameNonPostal;
        }
        for (Integer locIdForNameNonPostal : locIdsForNameNonPostal) {
            path = this.getPathToRoot(locIdForNameNonPostal);
            int pathIndex = 0;
            int pathLen = path.size();
            int foundCount = 0;
            block2: for (int i = ancestryLocations.size() - 1; i >= 0; --i) {
                name = ancestryLocations.get(i).getName();
                while (pathIndex < pathLen - 1) {
                    locId = path.get(pathIndex);
                    entry = this.getLocation(locId);
                    ++pathIndex;
                    if (!this.equalsNameOrAlias(name, entry)) continue;
                    ++foundCount;
                    continue block2;
                }
            }
            if (foundCount != ancestryLocations.size()) continue;
            result.add(locIdForNameNonPostal);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public boolean isGenericRegion(List<ISMLocation> locations) {
        if (locations == null || locations.isEmpty()) {
            return false;
        }
        String[] genericRegions = new String[]{"north", "south", "east", "west", "central", "north east", "north west", "south east", "south west", "northeast", "northwest", "southeast", "southwest", "eastern", "northern", "western", "southern"};
        int threshold = 80;
        List<String> list = Arrays.asList(genericRegions);
        int found = 0;
        for (ISMLocation loc : locations) {
            if (!list.contains(loc.getName().toLowerCase())) continue;
            ++found;
        }
        return found * 100 / locations.size() >= threshold;
    }

    public boolean isInACountry(Integer locId) {
        LocationEntry.Type type = this.getLocation(locId).getType();
        return type != LocationEntry.Type.WORLD && type != LocationEntry.Type.CONTINENT && type != LocationEntry.Type.SUBREGION && type != LocationEntry.Type.COUNTRY;
    }

    public List<Integer> getLocationIdsWithAncestor(String name, String ancestor) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<Integer> ancestorIds = this.getLocationIdsForName(ancestor);
        List<Integer> nameIds = this.getLocationIdsForName(name);
        if (ancestorIds == null || ancestorIds.size() == 0 || nameIds == null || nameIds.size() == 0) {
            return null;
        }
        for (int i = 0; i < ancestorIds.size(); ++i) {
            Integer ancestorId = ancestorIds.get(i);
            for (int j = 0; j < nameIds.size(); ++j) {
                Integer id;
                if (!this.isAncestor(ancestorId, nameIds.get(j)) || ids.contains(id = nameIds.get(j))) continue;
                ids.add(id);
            }
        }
        return ids;
    }
}

