/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.GeoJSONCoordinates;
import com.ibm.athena.smartermaps.model.GeoJSONFeature;
import com.ibm.athena.smartermaps.model.GeoJSONGeometry;
import com.ibm.athena.smartermaps.model.GeoJSONObject;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocationTableHandler {
    private static final String GEOJSON_RESOURCE = "/mapFiles/geoJSON.txt";
    private static final String LOCATION_TABLE_RESOURCE = "/mapFiles/LocationTable.xml";
    private Map<Integer, LocationEntry> locationTable = new HashMap<Integer, LocationEntry>();
    private Map<String, List<Integer>> namesTable = new HashMap<String, List<Integer>>();

    public LocationTableHandler() {
        try {
            this.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void create() throws Exception {
        HashMap<String, String> geoJSONMap = new HashMap<String, String>();
        InputStream inputStream = LocationTableHandler.class.getResourceAsStream(GEOJSON_RESOURCE);
        String fileContent = this.readFile(inputStream);
        if (fileContent == null) {
            throw new Exception("Exception: cannot read the geoJSON file");
        }
        StringTokenizer fileTokenizer = new StringTokenizer(fileContent, "\n");
        String line = null;
        while (fileTokenizer.hasMoreElements()) {
            line = ((String)fileTokenizer.nextElement()).trim();
            StringTokenizer st = new StringTokenizer(line, "%");
            String geoJSONLabel = (String)st.nextElement();
            String geoJSON = (String)st.nextElement();
            geoJSONMap.put(geoJSONLabel, geoJSON);
            if (!st.hasMoreElements()) continue;
            String pop = (String)st.nextElement();
            geoJSONMap.put(geoJSONLabel + ".pop", pop);
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        inputStream = LocationTableHandler.class.getResourceAsStream(LOCATION_TABLE_RESOURCE);
        Document doc = docBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList listOfLocations = doc.getElementsByTagName("location");
        Integer locationId = 1;
        for (int i = 0; i < listOfLocations.getLength(); ++i) {
            Element location = (Element)listOfLocations.item(i);
            NodeList textList = null;
            NodeList nameItem = location.getElementsByTagName("name");
            Element nameElement = (Element)nameItem.item(0);
            textList = nameElement.getChildNodes();
            String name = textList.item(0).getNodeValue().trim();
            NodeList typeItem = location.getElementsByTagName("type");
            Element typeElement = (Element)typeItem.item(0);
            textList = typeElement.getChildNodes();
            String typeString = textList.item(0).getNodeValue().trim();
            LocationEntry.Type type = null;
            LocationEntry.Type[] typeArr = LocationEntry.Type.values();
            for (int j = 0; j < typeArr.length; ++j) {
                if (!typeArr[j].name().equals(typeString)) continue;
                type = typeArr[j];
                break;
            }
            ArrayList<Integer> parentsArray = new ArrayList<Integer>();
            NodeList parentsItem = location.getElementsByTagName("parents");
            Element parentsElement = (Element)parentsItem.item(0);
            if (parentsElement != null) {
                NodeList parentsList = parentsElement.getElementsByTagName("p");
                for (int j = 0; j < parentsList.getLength(); ++j) {
                    String parentName = parentsList.item(j).getFirstChild().getNodeValue();
                    Integer parentId = this.getParentLocationId(parentName, name, type);
                    if (parentId == -1) continue;
                    LocationEntry parent = this.locationTable.get(parentId);
                    parent.addChild(locationId);
                    parentsArray.add(parentId);
                }
            }
            ArrayList<String> aliasArray = new ArrayList<String>();
            NodeList aliasItem = location.getElementsByTagName("alias");
            Element aliasElement = (Element)aliasItem.item(0);
            if (aliasElement != null) {
                NodeList aliasList = aliasElement.getElementsByTagName("a");
                for (int j = 0; j < aliasList.getLength(); ++j) {
                    String aliasName = aliasList.item(j).getFirstChild().getNodeValue();
                    aliasArray.add(aliasName);
                }
            }
            if (type == LocationEntry.Type.COUNTY) {
                LocationEntry parentEntry = this.locationTable.get(parentsArray.get(0));
                String parentName = parentEntry.getName();
                aliasArray.add(name + "-" + parentName);
                if (name.endsWith(" Parish")) {
                    aliasArray.add(name.replace(" Parish", ""));
                    aliasArray.add(name.replace(" Parish", "") + "-" + parentName);
                }
                if (name.startsWith("Saint ")) {
                    aliasArray.add("St. " + name.substring(6).replace(" Parish", ""));
                    aliasArray.add("St. " + name.substring(6).replace(" Parish", "") + "-" + parentName);
                }
            }
            ArrayList<String> childrenNamesArray = new ArrayList<String>();
            NodeList childrenItem = location.getElementsByTagName("children");
            Element childrenElement = (Element)childrenItem.item(0);
            if (childrenElement != null) {
                NodeList childrenList = childrenElement.getElementsByTagName("c");
                for (int j = 0; j < childrenList.getLength(); ++j) {
                    String childrenName = childrenList.item(j).getFirstChild().getNodeValue();
                    childrenNamesArray.add(childrenName);
                }
            }
            LocationEntry locationEntry = new LocationEntry(name, aliasArray, type, parentsArray, childrenNamesArray, null);
            String geoJSON = null;
            geoJSON = this.getGeoJSON(locationEntry, geoJSONMap);
            locationEntry.setGeoJSON(geoJSON);
            this.addToLocationTable(locationId, locationEntry);
            Integer n = locationId;
            Integer n2 = locationId = Integer.valueOf(locationId + 1);
        }
        String name = "French Guyana";
        ArrayList parentsArray = (ArrayList)this.namesTable.get("SouthernAmerica".toLowerCase());
        ArrayList<String> aliasArray = new ArrayList<String>();
        aliasArray.add("Guyane fran\u00e7aise");
        aliasArray.add("GF");
        aliasArray.add("GUF");
        String geoJSONStr = this.getFrenchGuyanaJSONString();
        LocationEntry locationEntry = new LocationEntry(name, aliasArray, LocationEntry.Type.COUNTRY, parentsArray, null, geoJSONStr);
        LocationEntry parent = this.locationTable.get(parentsArray.get(0));
        parent.addChild(locationId);
        this.addToLocationTable(locationId, locationEntry);
        Integer n = locationId;
        Integer n3 = locationId = Integer.valueOf(locationId + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readFile(InputStream inputStream) {
        String fileContent = "";
        StringBuffer fileContentB = new StringBuffer();
        int MAX_SIZE = 200000;
        char[] buffer = new char[200000];
        BufferedReader reader = null;
        try {
            int nb;
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            do {
                if ((nb = reader.read(buffer, 0, 200000)) < 200000) {
                    fileContentB.append(String.valueOf(buffer).substring(0, nb - 1));
                    continue;
                }
                fileContentB.append(buffer);
            } while (nb == 200000);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        fileContent = fileContentB.toString().trim();
        return fileContent;
    }

    private String getFrenchGuyanaJSONString() {
        ArrayList idsWesternEurope = (ArrayList)this.namesTable.get("WesternEurope".toLowerCase());
        LocationEntry westernEuropeEntry = this.locationTable.get(idsWesternEurope.get(0));
        GeoJSONObject westernEuropeGeoJSON = new GeoJSONObject(westernEuropeEntry);
        GeoJSONGeometry franceGeometry = westernEuropeGeoJSON.getGeometry("France");
        GeoJSONCoordinates franceCoordinates = franceGeometry.getCoordinates();
        GeoJSONCoordinates firstCoord = franceCoordinates.get(0);
        franceCoordinates.remove(0);
        GeoJSONFeature frenchGuyanaFeature = new GeoJSONFeature();
        frenchGuyanaFeature.setName("French Guyana");
        frenchGuyanaFeature.addProperty("continent", "South America");
        GeoJSONGeometry frenchGuyanaGeometry = frenchGuyanaFeature.getGeometry();
        frenchGuyanaGeometry.setType("Polygon");
        frenchGuyanaGeometry.setCoordinates(firstCoord);
        frenchGuyanaFeature.setGeometry(frenchGuyanaGeometry);
        ArrayList idsSouthernAmerica = (ArrayList)this.namesTable.get("SouthernAmerica".toLowerCase());
        LocationEntry southernAmericaEntry = this.locationTable.get(idsSouthernAmerica.get(0));
        GeoJSONObject southernAmericaGeoJSON = new GeoJSONObject(southernAmericaEntry);
        southernAmericaGeoJSON.addFeature(frenchGuyanaFeature.getJSON());
        southernAmericaEntry.setGeoJSON(southernAmericaGeoJSON.toString());
        return null;
    }

    private String getGeoJSON(LocationEntry locationEntry, Map<String, String> geoJSONMap) {
        String geoJSON = null;
        LocationEntry.Type type = locationEntry.getType();
        if (type == LocationEntry.Type.REGION || type == LocationEntry.Type.GROUP || type == LocationEntry.Type.PROVINCE && !this.isUSState(locationEntry)) {
            geoJSON = "parent";
        } else {
            String pop;
            String geoJSONLabel = this.createLabel(locationEntry);
            geoJSON = geoJSONMap.get(geoJSONLabel);
            if (type == LocationEntry.Type.CITY && (pop = geoJSONMap.get(geoJSONLabel + ".pop")) != null) {
                locationEntry.setPop(Integer.parseInt(pop));
            }
        }
        return geoJSON;
    }

    private boolean isUSState(LocationEntry locationEntry) {
        List<Integer> parentIds = locationEntry.getParents();
        LocationEntry parentEntry = this.locationTable.get(parentIds.get(0));
        if (parentEntry.getName().equals("United States of America")) {
            return true;
        }
        parentIds = parentEntry.getParents();
        return (parentEntry = this.locationTable.get(parentIds.get(0))).getName().equals("United States of America");
    }

    void addToLocationTable(Integer locationId, LocationEntry locationEntry) {
        this.locationTable.put(locationId, locationEntry);
        ArrayList<String> newNames = new ArrayList<String>();
        newNames.add(locationEntry.getName());
        newNames.addAll(locationEntry.getAliases());
        for (String newName : newNames) {
            List<Integer> indList = this.namesTable.get(newName = this.normalize(newName));
            if (indList == null) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(locationId);
                this.namesTable.put(newName, list);
                continue;
            }
            if (indList.contains(locationId)) continue;
            indList.add(locationId);
        }
    }

    public String normalize(String inputName) {
        String newName = inputName.replaceAll(" ", "");
        newName = Normalizer.normalize(newName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        return newName.toLowerCase();
    }

    public List<Integer> getAllLocationIds(String name) {
        String newName = this.normalize(name);
        return this.namesTable.get(newName);
    }

    void replaceNameInGeoJSON(JSONObject geoJSON, LocationEntry entry, String newName) {
        JSONObject gj;
        JSONObject featureObj = this.getFeatureForEntry(geoJSON, entry);
        if (featureObj != null) {
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            propObj.put((Object)"name", (Object)newName);
        }
        if ((gj = (JSONObject)geoJSON.get((Object)"cities")) != null && (featureObj = this.getFeatureForEntry(geoJSON, entry)) != null) {
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            propObj.put((Object)"name", (Object)newName);
        }
        if (entry.getType().equals((Object)LocationEntry.Type.REGION)) {
            List<JSONObject> regionFeatures = this.getRegionFeaturesForEntry(geoJSON, entry);
            for (JSONObject region : regionFeatures) {
                JSONObject propObj = (JSONObject)region.get((Object)"properties");
                propObj.put((Object)"region", (Object)newName);
            }
        }
    }

    public JSONObject getFeatureForEntry(JSONObject geoJSON, LocationEntry entry) {
        String name = entry.getName();
        Integer pid = entry.getFirstParentId();
        String parentName = this.locationTable.get(pid).getName();
        JSONArray featuresObjArr = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name1 = propObj.get((Object)"name").toString();
            String admin = (String)propObj.get((Object)"ADMIN");
            if (!name.equals(name1)) continue;
            if (pid < 8) {
                return featureObj;
            }
            if ((name.equals("Puerto Rico") || name.equals("Guam")) && admin != null) {
                return featureObj;
            }
            String subRegion = (String)propObj.get((Object)"SUBREGION");
            if (subRegion != null && subRegion.equals(parentName)) {
                return featureObj;
            }
            String region = (String)propObj.get((Object)"region");
            if (region != null && region.equals(parentName)) {
                return featureObj;
            }
            if (admin != null && admin.equals(parentName)) {
                return featureObj;
            }
            String state = (String)propObj.get((Object)"state");
            if (state == null || !state.equals(parentName)) continue;
            return featureObj;
        }
        return null;
    }

    public List<JSONObject> getRegionFeaturesForEntry(JSONObject geoJSON, LocationEntry entry) {
        ArrayList<JSONObject> features = new ArrayList<JSONObject>();
        String name = entry.getName();
        JSONArray featuresObjArr = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            String region;
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            if (!propObj.containsKey((Object)"region") || !name.equals(region = propObj.get((Object)"region").toString())) continue;
            features.add(featureObj);
        }
        return features;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer getParentLocationId(String pName, String name, LocationEntry.Type type) {
        if (!pName.contains(":")) {
            List<Integer> locIds = this.getAllLocationIds(pName);
            if (locIds == null || locIds.size() == 0) {
                System.out.println("parent not found for " + pName);
                return -1;
            }
            if (locIds.size() <= 1) return locIds.get(0);
            for (int i = 0; i < locIds.size(); ++i) {
                int locId = locIds.get(i);
                List<String> childrenNames = this.locationTable.get(locId).getChildrenNames();
                if (!childrenNames.contains(name)) continue;
                return locId;
            }
        } else {
            StringTokenizer st = new StringTokenizer(pName, ":");
            String name1 = (String)st.nextElement();
            List<Integer> parentIds = this.getAllLocationIds(name1);
            Integer parentId = parentIds.get(0);
            block1: while (st.hasMoreElements()) {
                name1 = (String)st.nextElement();
                List<Integer> childrenIds = this.locationTable.get(parentId).getChildren();
                for (Integer childId : childrenIds) {
                    if (!this.locationTable.get(childId).getName().equals(name1)) continue;
                    parentId = childId;
                    continue block1;
                }
            }
            return parentId;
        }
        System.out.println("child name not found");
        return null;
    }

    String createLabel(LocationEntry locationEntry) {
        String label = locationEntry.getName();
        LocationEntry entry1 = locationEntry;
        LocationEntry.Type type = entry1.getType();
        while (type == LocationEntry.Type.PROVINCE || type == LocationEntry.Type.REGION || type == LocationEntry.Type.CITY || type == LocationEntry.Type.GROUP) {
            Integer parentId = entry1.getFirstParentId();
            LocationEntry parentEntry = this.locationTable.get(parentId);
            type = parentEntry.getType();
            if (type != LocationEntry.Type.GROUP) {
                label = parentEntry.getName() + "." + label;
            }
            entry1 = parentEntry;
        }
        return label;
    }

    public Map<Integer, LocationEntry> getLocationTable() {
        return this.locationTable;
    }

    public boolean equalsNormalized(String name, String name2) {
        return this.normalize(name).equals(this.normalize(name2));
    }
}

