/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.LocationEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocationTableHandlerPB {
    private Map<Integer, LocationEntry> locationTable = new HashMap<Integer, LocationEntry>();
    private Map<String, List<Integer>> namesTable = new HashMap<String, List<Integer>>();
    private static String[][] nameMapList = new String[][]{{"n", "national-170131"}, {"npo", "nationalpoint"}, {"npl", "nationalpoly"}, {"a1", "admin-1-170131"}, {"a1po", "admin1point"}, {"a1pl", "admin1poly"}, {"a2", "admin-2-170131"}, {"a2po", "admin2point"}, {"a2pl", "admin2poly"}, {"a3", "admin-3-170131"}, {"a3po", "admin3point"}, {"a3pl", "admin3poly"}, {"a4", "admin-4-170131"}, {"a4po", "admin4point"}, {"a4pl", "admin4poly"}, {"a5", "admin-5-170131"}, {"a5po", "admin5point"}, {"a5pl", "admin5poly"}, {"p1", "post-1-170131"}, {"p1po", "post1point"}, {"p1pl", "post1poly"}, {"p2", "post-2-170131"}, {"p2po", "post2point"}, {"p2pl", "post2poly"}, {"p3", "post-3-170131"}, {"p3po", "post3point"}, {"p3pl", "post3poly"}, {"a1fr", "admin-1FR-170513"}, {"a1frpo", "admin1FRpoint"}, {"a1frpl", "admin1FRpoly"}};
    private static Map<String, String> shortToLongNameMap = new HashMap<String, String>();
    private static Map<String, String> longToShortNameMap = new HashMap<String, String>();

    public LocationTableHandlerPB() {
        try {
            LocationTableHandlerPB.buildShortNameMap();
            this.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void buildShortNameMap() {
        for (int i = 0; i < nameMapList.length; ++i) {
            String[] a = nameMapList[i];
            String shortName = a[0];
            String longname = a[1];
            shortToLongNameMap.put(shortName, longname);
            longToShortNameMap.put(longname, shortName);
        }
    }

    public static String getShortname(String longName) {
        return longToShortNameMap.get(longName);
    }

    public static String getLongName(String shortName) {
        return shortToLongNameMap.get(shortName);
    }

    private void create() throws Exception {
        String locationTablePath = "/mapFiles/LocationTablePB.txt";
        InputStream inputStreamPB = LocationTableHandlerPB.class.getResourceAsStream(locationTablePath);
        String endingsFilePath = "/mapFiles/endings.txt";
        InputStream inputStreamPEndings = LocationTableHandlerPB.class.getResourceAsStream(endingsFilePath);
        HashMap<String, List<String>> endingsMap = new HashMap<String, List<String>>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStreamPEndings));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] fields = line.split("@");
            String country = fields[0];
            String[] fields1 = fields[1].split("#");
            List<String> endings = Arrays.asList(fields1);
            endingsMap.put(country, endings);
        }
        Integer locationId = 1;
        int indexEnding = 0;
        br = new BufferedReader(new InputStreamReader(inputStreamPB, "UTF8"));
        line = br.readLine();
        while ((line = br.readLine()) != null) {
            String path;
            List endings;
            int j;
            String[] fields = line.split("\t");
            String countryCode = fields[1];
            String pk = fields[0];
            String name = fields[2];
            String mapid = fields[3];
            String pointLayer = fields[4];
            String polyLayer = fields[5];
            int index = 6;
            String parent = null;
            if (fields.length > index) {
                parent = fields[6];
            }
            index = 7;
            String[] aliases = null;
            if (fields.length > index && !fields[index].isEmpty()) {
                aliases = fields[index].substring(1, fields[index].length() - 1).split("#");
            }
            index = 8;
            String[] children = null;
            if (fields.length > index && !fields[index].isEmpty()) {
                children = fields[index].substring(1, fields[index].length() - 1).split(", ");
            }
            index = 9;
            String[] childrenNames = null;
            if (fields.length > index && !fields[index].isEmpty()) {
                childrenNames = fields[index].split("#");
            }
            LocationEntry locationEntry = new LocationEntry(name);
            locationEntry.setMapId(mapid);
            locationEntry.setPointLayer(pointLayer);
            locationEntry.setPolyLayer(polyLayer);
            locationEntry.setCountryCode(countryCode);
            if (!pk.isEmpty()) {
                locationEntry.setPk(pk);
            }
            if (parent != null && !parent.isEmpty()) {
                locationEntry.addParent(Integer.valueOf(parent));
            }
            if (children != null) {
                for (j = 0; j < children.length; ++j) {
                    locationEntry.addChild(Integer.valueOf(children[j]));
                }
            }
            if (childrenNames != null) {
                for (j = 0; j < childrenNames.length; ++j) {
                    locationEntry.addChildName(childrenNames[j]);
                }
            }
            if ((endings = (List)endingsMap.get(countryCode)) != null) {
                for (String ending : endings) {
                    if (!name.endsWith(ending)) continue;
                    indexEnding = name.lastIndexOf(ending);
                    String alias = name.substring(0, indexEnding).trim();
                    locationEntry.addAlias(alias);
                }
            }
            if (aliases != null) {
                for (int j2 = 0; j2 < aliases.length; ++j2) {
                    locationEntry.addAlias(aliases[j2]);
                }
            }
            if (!countryCode.equals("**") && (path = this.getPath(locationEntry, countryCode)) != null) {
                locationEntry.setPath(path);
            }
            this.addToLocationTable(locationId, locationEntry);
            Integer n = locationId;
            Integer n2 = locationId = Integer.valueOf(locationId + 1);
        }
    }

    public String getPath(LocationEntry entry, String iso2) {
        if (entry == null) {
            return null;
        }
        String mapid = entry.getMapId();
        if (mapid.startsWith("p")) {
            return entry.getCountryCode();
        }
        Integer parentId = entry.getFirstParentId();
        String path = "";
        String name = "";
        while (!mapid.startsWith("n")) {
            entry = this.locationTable.get(parentId);
            if (entry == null) {
                return null;
            }
            name = entry.getMapId().startsWith("n") ? iso2 : entry.getName();
            path = name + "@" + path;
            parentId = entry.getFirstParentId();
            mapid = entry.getMapId();
        }
        if (!path.isEmpty()) {
            path = path.substring(0, path.length() - 1);
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream inputStream) throws Exception {
        inputStream.mark(2);
        byte[] bom = new byte[2];
        inputStream.read(bom);
        String fileType = bom[0] == -1 || bom[0] == -2 ? "UTF16" : "UTF8";
        inputStream.reset();
        String fileContent = "";
        StringBuffer fileContentB = new StringBuffer();
        int MAX_SIZE = 200000;
        char[] buffer = new char[200000];
        BufferedReader reader = null;
        try {
            int nb;
            reader = new BufferedReader(new InputStreamReader(inputStream, fileType));
            do {
                if ((nb = reader.read(buffer, 0, 200000)) < 200000) {
                    fileContentB.append(String.valueOf(buffer).substring(0, nb - 1));
                    continue;
                }
                fileContentB.append(buffer);
            } while (nb == 200000);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        fileContent = fileContentB.toString().trim();
        return fileContent;
    }

    void addToLocationTable(Integer locationId, LocationEntry locationEntry) {
        this.locationTable.put(locationId, locationEntry);
        ArrayList<String> newNames = new ArrayList<String>();
        newNames.add(locationEntry.getName());
        newNames.addAll(locationEntry.getAliases());
        for (String newName : newNames) {
            List<Integer> indList = this.namesTable.get(newName = this.normalize(newName));
            if (indList == null) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(locationId);
                this.namesTable.put(newName, list);
                continue;
            }
            if (indList.contains(locationId)) continue;
            indList.add(locationId);
        }
    }

    public String normalize(String inputName) {
        String newName = inputName.replaceAll(" ", "");
        newName = Normalizer.normalize(newName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("\u00d0|\u0110", "D").replaceAll("\u0142", "l");
        return newName.toLowerCase();
    }

    public List<Integer> getAllLocationIds(String name) {
        String newName = this.normalize(name);
        return this.namesTable.get(newName);
    }

    public Map<Integer, LocationEntry> getLocationTable() {
        return this.locationTable;
    }

    public boolean equalsNormalized(String name, String name2) {
        return this.normalize(name).equals(this.normalize(name2));
    }
}

