/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MapIndexer {
    private static List<MapIndexer> mapList = null;
    private JSONObject geoJson = null;
    private Map<Integer, String> locations = null;

    private MapIndexer(String jsonFileName, String locationsFileName) {
        try {
            this.loadLocations(locationsFileName);
            this.loadJson(jsonFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<MapIndexer> getNonMapIndexers() {
        if (mapList == null) {
            mapList = new ArrayList<MapIndexer>();
            String mapsDir = "/mapFiles/";
            mapList.add(new MapIndexer(mapsDir + "stadium_json.txt", mapsDir + "stadium_locations.txt"));
        }
        return mapList;
    }

    public void loadJson(String jsonFileName) throws IOException {
        InputStream inputStream = MapIndexer.class.getResourceAsStream(jsonFileName);
        this.geoJson = JSONObject.parse((InputStream)inputStream);
    }

    public void loadLocations(String locationsFileName) throws IOException {
        this.locations = new HashMap<Integer, String>();
        InputStream inputStream = MapIndexer.class.getResourceAsStream(locationsFileName);
        BufferedReader locationsReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        String fileContent = null;
        try {
            fileContent = this.readFile(inputStream);
        }
        catch (Exception e) {
            inputStream.close();
            throw new IOException(" Input Stream not found: " + locationsFileName);
        }
        StringTokenizer fileTokenizer = new StringTokenizer(fileContent, "\n");
        String line = null;
        int locPos = 0;
        while (fileTokenizer.hasMoreElements()) {
            line = (String)fileTokenizer.nextElement();
            this.locations.put(locPos++, line.trim());
        }
        locationsReader.close();
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(InputStream inputStream) throws IOException {
        String fileContent = "";
        StringBuffer fileContentB = new StringBuffer();
        int MAX_SIZE = 200000;
        char[] buffer = new char[200000];
        BufferedReader reader = null;
        try {
            int nb;
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            do {
                if ((nb = reader.read(buffer, 0, 200000)) < 200000) {
                    fileContentB.append(String.valueOf(buffer).substring(0, nb - 1));
                    continue;
                }
                fileContentB.append(buffer);
            } while (nb == 200000);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            reader.close();
            inputStream.close();
        }
        fileContent = fileContentB.toString().trim();
        return fileContent;
    }

    public Map<Integer, String> getLocations() {
        return this.locations;
    }

    public JSONObject getGeoJSON() {
        return this.geoJson;
    }
}

