/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.math.BigDecimal;

public class MapsUtilities {
    private ModificationType modifType = ModificationType.RESIZE;
    private int longDiff = -1000;
    private int latDiff = -1000;
    private double resizeFactor = 1.0;
    private double baseLong = 200.0;
    private double baseLat = 200.0;

    public JSONObject removePart(JSONObject geoJSON, String name) {
        JSONArray features = (JSONArray)geoJSON.get((Object)"features");
        JSONArray newFeatures = new JSONArray();
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject properties = (JSONObject)feature.get((Object)"properties");
            if (properties.get((Object)"name").equals(name)) continue;
            newFeatures.add((Object)feature);
        }
        geoJSON.put((Object)"features", (Object)newFeatures);
        return geoJSON;
    }

    public JSONObject reducePart(JSONObject geoJSON, String name, double rFactor) {
        this.resizeFactor = rFactor;
        this.modifType = ModificationType.RESIZE;
        return this.modifySpec(geoJSON, name);
    }

    public JSONObject modifySpec(JSONObject geoJSON, String name) {
        JSONArray features = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject properties = (JSONObject)feature.get((Object)"properties");
            String name1 = (String)properties.get((Object)"name");
            if (!name1.equals(name)) continue;
            JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
            JSONArray coord = (JSONArray)geometry.get((Object)"coordinates");
            JSONArray newCoord = this.modifyCoordinatesArray(coord, 2);
            geometry.put((Object)"coordinates", (Object)newCoord);
        }
        JSONObject countiesGeoJSON = (JSONObject)geoJSON.get((Object)"counties");
        if (countiesGeoJSON == null) {
            return geoJSON;
        }
        JSONArray countiesFeatures = (JSONArray)countiesGeoJSON.get((Object)"features");
        for (int i = 0; i < countiesFeatures.size(); ++i) {
            JSONObject feature = (JSONObject)countiesFeatures.get(i);
            JSONObject properties = (JSONObject)feature.get((Object)"properties");
            String stateName = (String)properties.get((Object)"state");
            if (!stateName.equals(name)) continue;
            String nameInProperties1 = (String)properties.get((Object)"name");
            JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
            JSONArray coord = (JSONArray)geometry.get((Object)"coordinates");
            JSONArray newCoord = this.modifyCoordinatesArray(coord, 2);
            if (this.modifType == ModificationType.RESIZE && nameInProperties1.startsWith("Aleutians West")) continue;
            geometry.put((Object)"coordinates", (Object)newCoord);
        }
        geoJSON.put((Object)"counties", (Object)countiesGeoJSON);
        return geoJSON;
    }

    public JSONArray modifyCoordinatesArray(JSONArray coordinatesObjArr, int nbDec) {
        JSONArray newCoordinatesObjArr = new JSONArray();
        if (coordinatesObjArr == null || coordinatesObjArr.isEmpty() || coordinatesObjArr.get(0) == null) {
            return null;
        }
        if (coordinatesObjArr.get(0).getClass() == Double.class) {
            Double d1 = (Double)coordinatesObjArr.get(0);
            Double d2 = (Double)coordinatesObjArr.get(1);
            d1 = this.processLong(d1);
            d2 = this.processLat(d2);
            d1 = this.formatCoordinate(d1, nbDec);
            d2 = this.formatCoordinate(d2, nbDec);
            newCoordinatesObjArr.add((Object)d1);
            newCoordinatesObjArr.add((Object)d2);
        } else {
            for (int j = 0; j < coordinatesObjArr.size(); ++j) {
                Object coordinatesObj = coordinatesObjArr.get(j);
                JSONArray coordinatesObjSubArray = (JSONArray)coordinatesObj;
                JSONArray modifArr = this.modifyCoordinatesArray(coordinatesObjSubArray, nbDec);
                if (modifArr == null) continue;
                newCoordinatesObjArr.add((Object)modifArr);
            }
        }
        return newCoordinatesObjArr;
    }

    private Double formatCoordinate(Double dlatlong, int decimalPlaces) {
        BigDecimal bd_Latlong = new BigDecimal(dlatlong);
        bd_Latlong = bd_Latlong.setScale(decimalPlaces, 4);
        dlatlong = bd_Latlong.doubleValue();
        return dlatlong;
    }

    private Double processLat(Double d) {
        Double result = null;
        if (this.modifType == ModificationType.MOVE) {
            result = d + (double)this.latDiff;
        } else if (this.baseLat == 200.0) {
            this.baseLat = d;
            result = d;
        } else {
            result = this.baseLat + (d - this.baseLat) * this.resizeFactor;
        }
        return result;
    }

    private Double processLong(Double d) {
        if (this.modifType == ModificationType.MOVE) {
            return d + (double)this.longDiff;
        }
        if (this.baseLong == 200.0) {
            this.baseLong = d;
            return d;
        }
        return this.baseLong + (d - this.baseLong) * this.resizeFactor;
    }

    public JSONObject moveUSState(JSONObject geoJSON, String name, int diffLong, int diffLat) {
        this.modifType = ModificationType.MOVE;
        this.longDiff = diffLong;
        this.latDiff = diffLat;
        return this.modifySpec(geoJSON, name);
    }

    public static String removeExtraWS(String inputName) {
        String name = inputName.trim();
        name = name.replaceAll("\\s+", " ").replaceAll("\\s+\\.", ".");
        return name;
    }

    public static String removeLastChar(String name) {
        return name.substring(0, name.length() - 1);
    }

    public JSONArray processEuropeanRussia(JSONArray coordinatesObjArr) {
        JSONArray newCoordinatesObjArr = new JSONArray();
        Object obj = coordinatesObjArr.get(0);
        if (obj instanceof Double) {
            Double lon = (Double)coordinatesObjArr.get(0);
            Double lat = (Double)coordinatesObjArr.get(1);
            if (lon > 0.0 && lon < 61.0 && lat < 72.0) {
                return coordinatesObjArr;
            }
        } else {
            for (int i = 0; i < coordinatesObjArr.size(); ++i) {
                JSONArray newAr = this.processEuropeanRussia((JSONArray)coordinatesObjArr.get(i));
                if (newAr == null) continue;
                newCoordinatesObjArr.add((Object)newAr);
            }
            if (newCoordinatesObjArr.size() > 0) {
                return newCoordinatesObjArr;
            }
        }
        return null;
    }

    private static enum ModificationType {
        RESIZE,
        MOVE;

    }
}

