/**
 * Generates a vizdef.xml and vizdef.xml.js in a specified output location. The vizdef
 * is generated from a given input vizdef location.
 * @param _path Location where a source vizdef.xml can be found.
 * @param _outputPath Output location for vizdef.xml and vizdef.xml.js.
 * @returns A promise that resolves when the output vizdef is created.
 */
export declare function genVizDef(_path: string, _outputPath: string): Promise<void>;
/**
 * Generates a manifest.xml and manifest.xml.js in a specified output location. The
 * manifest is either generated from an existing manifest in a source location, or
 * created from scratch based on a manifest template (see beginning of this file).
 * @param _path Location where a source manifest might be found.
 * @param _outputPath Output location for manifest.xml and manifest.xml.js.
 * @returns A promise that resolves when the output manifest is created.
 */
export declare function genManifest(_path: string, _outputPath: string): Promise<void>;
/**
 * Generates a meta.json file in the specified output location. The meta.json is
 * generated from a source package.json and the information found in the package.json
 * of customvis-lib and cli.
 * @param _path Path where the source package.json (of the bundle) can be found.
 * @param _outputPath Output location for meta.json.
 * @returns A promise that resolves when the meta.json is created.
 */
export declare function genMetaInfo(_path: string, _outputPath: string): Promise<void>;
