import { IOverrides } from "./transpile";
/**
 * Prepare and build a bundle at the `_path`
 * @param _path
 * @param _rollupOverrides additional rollup options which can be used to override the default config
 */
export declare function build(_path: string, _rollupOverrides?: Partial<IOverrides>): Promise<void>;
/**
 * Prepare and start watching a bundle at the `_path`
 * @param _path
 * @param _rollupOverrides additional rollup options which can be used to override the default config
 */
export declare function watch(_path: string, _rollupOverrides?: Partial<IOverrides>): Promise<Function>;
