"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const tsNode = require("ts-node");
const fs = require("../utils/fs");
const path = require("path");
/**
 * Create a typescript program using ts-node. Used by 'transpile.ts'.
 * @param _rootPath the root path of the typescript project.
 * @returns An object with a 'typeCheck' function that can be called to perform
 * typescript validation on a file.
 */
function createTypescriptProgram(_rootPath) {
    // Create a ts-node instance with default settings (not strict).
    const service = tsNode.create({
        files: true,
        dir: _rootPath,
        skipProject: false,
        compilerOptions: {
            strict: false,
            noEmit: true,
            sourceMap: false
        }
    });
    return {
        async typeCheck(_entryFile) {
            // Only validate .ts files.
            if (path.extname(_entryFile).slice(1) !== "ts")
                return;
            const fileInput = await fs.readFile(_entryFile);
            service.compile(fileInput, _entryFile);
        }
    };
}
exports.createTypescriptProgram = createTypescriptProgram;
