"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const bundler = require("..");
const logging_1 = require("./logging");
async function withError(_message, _promise) {
    try {
        return await _promise;
    }
    catch (_err) {
        if (_err && _err.message)
            logging_1.printError(_message, _err.message);
        else
            logging_1.printError(_message);
        bundler.getProcess().exit(1);
    }
}
exports.create = (_currentPath) => (_name, _options) => withError(`Failed to create "${_name}" visualization.`, bundler.create(_currentPath, _name, _options));
exports.list = () => () => withError("Failed to list templates.", bundler.getTemplates().then(_templates => _templates.forEach((_t) => console.log(_t))));
exports.start = (_currentPath) => (_options) => withError("Failed to start the bundle.", bundler.start(_currentPath, _options));
exports.pack = (_currentPath) => () => withError("Failed to pack the bundle.", bundler.pack(_currentPath));
exports.build = (_currentPath) => () => withError("Failed to build the bundle.", bundler.build(_currentPath, { output: { sourcemap: false } }));
exports.clean = (_currentPath) => () => withError("Failed to clean up the bundle.", bundler.clean(_currentPath).then(() => logging_1.printInfo("Done cleaning.")));
exports.upgrade = (_currentPath) => () => withError("Failed to upgrade the customvis-lib", bundler.upgrade(_currentPath).then(_upInfo => logging_1.printInfo(`Done upgrading customvis-lib from ${_upInfo.oldVersion} to ${_upInfo.currentVersion}`)));
exports.info = (_currentPath) => () => withError("Failed to get information.", bundler.info(_currentPath).then(console.log));
