"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Logs prefixed messages to the console. A time stamp is added to each message.
 * @param _prefix Prefix for each message
 * @param args Messages to print to the console.
 * @example
 * notify( "[Error]", "This is an error" );
 * notify( "[Error]", "First error", "Second error" );
 */
function notify(_prefix, ...args) {
    const time = `[${new Date().toLocaleTimeString()}]`;
    args.forEach(_msg => console.log(_prefix, time, _msg));
}
exports.notify = notify;
