export declare const LIB_PACKAGE_NAME = "@businessanalytics/customvis-lib";
export declare const LIB_PACKAGE_PATH: string;
export declare const LIB_PACKGE_FILE_IN_VIS = "customvis-lib.tgz";
export declare const D3_EXTERNAL_LINK = "https://d3js.org/d3.v5.min.js";
export declare const DEFAULT_TEMPLATE = "Basic";
export declare const IGNORED_FILES: string[];
export declare const OUTPUT_DIR = "build";
export declare const DEFAULT_PORT = 8585;
export declare const STATIC_FILES: string[];
export declare const ROLLUP_CONFIG = "rollup.config.js";
export declare const ROLLUP_DEPS = "rollup-dependencies.json";
export declare const BUILDER_EVENT = "BUILDER_EVENT";
export declare const BUILDER_ERROR = "BUILDER_ERROR";
export declare enum BUILDER_EVENTS {
    CREATING_NEW_PROJECT = 0,
    DONE_CREATING_PROJECT = 1,
    START_UPGRADING_LIB = 2,
    DONE_UPGRADING_LIB = 3,
    INSTALLING_DEPENDENCIES = 4,
    SERVER_STARTING = 5,
    SERVER_STARTED = 6,
    SERVER_STOPPED = 7,
    GENERATING_VIZDEF = 8,
    GENERATING_MANIFEST = 9,
    GENERATING_META = 10,
    START_BUILDING = 11,
    DONE_BUILDING = 12,
    START_WATCHING = 13,
    STOPPED_WATCHING = 14,
    START_PACKING = 15,
    START_ZIPPING = 16,
    DONE_ZIPPING = 17,
    DONE_PACKING = 18,
    START_TRANSPILING = 19,
    DONE_TRANSPILING = 20
}
export declare const enum BUILDER_ERROR_EVENTS {
    FAILED_TRANSPILING = 0,
    FAILED_GEN_MANIFEST = 1,
    FAILED_GEN_META = 2,
    FAILED_GEN_VIZDEF = 3,
    SERVER_PORT_IN_USE = 4,
    SERVER_FAILED_TO_START = 5
}
/**
 * meta.json structure
 */
export declare type TMeta = {
    name: string;
    id: string;
    type: "renderer";
    version: string;
    description: string;
    cliVersion: string;
    apiVersion: string;
    libVersion: string;
    icon?: string;
};
