"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("./utils/fs");
const path = require("path");
const build = require("./build");
const constants_1 = require("./constants");
const events_1 = require("./utils/events");
/**
 * Build and zip a bundle. The name of the zip file will be <basename>.packed.zip
 * where basename is the base name of the bundle.
 * @param _path The absolute path where the bundle is located.
 * @returns A promise that resolves with the full path name of the zip file.
 */
async function pack(_path) {
    events_1.emitEvent(constants_1.BUILDER_EVENTS.START_PACKING);
    const outputPath = path.join(_path, constants_1.OUTPUT_DIR);
    // Build without sourcemaps.
    await build.build(_path, { output: { sourcemap: false } });
    events_1.emitEvent(constants_1.BUILDER_EVENTS.START_ZIPPING);
    const fileName = path.basename(_path) + ".packed";
    const output = await fs.zipBundle(outputPath, _path, fileName);
    events_1.emitEvent(constants_1.BUILDER_EVENTS.DONE_ZIPPING);
    events_1.emitEvent(constants_1.BUILDER_EVENTS.DONE_PACKING, output);
    return output;
}
exports.pack = pack;
