/// <reference types="node" />
import * as http from "http";
export interface IServerOptions {
    headers: http.OutgoingHttpHeaders;
    port: number;
    https: boolean;
    contentBase: string[];
}
/**
 * Get a mime-type for a file
 * @param _filePath absolute path to a file
 */
export declare function getMimeType(_filePath: string): string;
/**
 * Create a request listener function to serves static files.
 * @param _options
 */
export declare function createReqListener(_options: IServerOptions): http.RequestListener;
