/// <reference types="node" />
import * as fs from "fs-extra";
import * as chokidar from "chokidar";
/**
 * Returns the absolute path to the sdk's static folder. Typically this is the
 * folder where the sdk keeps rollup configuration files.
 * @returns The absolute path of the sdk folder where static files are located.
 */
export declare function getStaticPath(): string;
/**
 * Returns the absolute path to the sdk's template folder.
 * @returns The absolute path of the sdk folder where templates are located.
 */
export declare function getTemplatePath(): string;
/**
 * Returns true if the bundle found at the specified location is a 'development bundle'.
 * A bundle is considered a 'development bundle' if it has a 'package.json' and contains
 * source code that can be built by customvis. A non-development bundle typically is one
 * that is already built by customvis and has no source code or package.json.
 * @param _path Path of a bundle.
 * @returns A promise that resolves with a boolean: true if the bundle is a development
 * bundle, false otherwise.
 */
export declare function isDevBundle(_path: string): Promise<boolean>;
/**
 * Performs a 'require' of a module. If the module has an exported 'default', then
 * this is returned instead of the module.
 * @param _path Path of a module.
 * @returns The required module or the default export from the module.
 */
export declare function moduleRequire(_path: string): any;
/**
 * Generate a zip file
 * @param _targetDir the directory which is being zipped
 * @param _destDir the directory which the zip file will be written to
 * @param _name the name of the final zip file
 */
export declare function zipBundle(_targetDir: string, _destDir: string, _name: string): Promise<string>;
export declare function exists(_path: string): Promise<boolean>;
export declare function copy(_src: string, _dest: string): Promise<void>;
export declare function readJSON(_file: string): Promise<any>;
export declare function writeJSON(_file: string, _object: any, _options?: fs.WriteOptions): Promise<any>;
export declare function readdir(_path: string): Promise<string[]>;
export declare function remove(_path: string): Promise<void>;
export declare function ensureDir(_path: string): Promise<void>;
export declare function readFile(_sourcePath: string): Promise<string>;
export declare function writeFile(_targetPath: string, _content: any, _options: fs.WriteFileOptions): Promise<void>;
export declare function stat(_filePath: string): Promise<fs.Stats>;
export declare function watchFiles(_input: string | string[], _options?: chokidar.WatchOptions): chokidar.FSWatcher;
