/**
 * Retrieve the full path of a named template. If no template name is specified, the
 * path of the default template (Basic) is returned.
 * @param _template Name of a template (e.g. Basic)
 * @returns Full path of the template.
 */
export declare function getTemplatePath(_template?: string): string;
/**
 * Returns a list of available templates. The list contains only the template names.
 * If you want to get the full path of a template, call `getTemplatePath`.
 * @returns A list of available template names.
 */
export declare function getTemplates(): Promise<string[]>;
