/**
 * Checks if an XML string has valid XML syntax.
 * @param _xmlString A string containing XML content.
 * @returns A promise that resolves with true if the XML content is valid. If the
 * XML content is not valid, the promise is resolved with false.
 */
export declare function isValidXML(_xmlString: string): Promise<boolean>;
/**
 * Converts an XML string to a JSON object.
 * @param _xmlString A string containing XML content.
 * @returns A promise that resolves with an object representing the XML. If the
 * XML content is invalid, the promise is rejected.
 */
export declare function getJSONFromXML(_xmlString: string): Promise<any>;
/**
 * Converts an XML string to a string that represents a JavaScript module that returns
 * that XML string. Typically this function is used when creating manifest.xml.js or
 * vizdef.xml.js.
 * @param _content A string containing XML content.
 * @returns A string representing a JavaScript module that returns the XML content.
 */
export declare function asModule(_content: string): string;
