# SDK

## SDK Components
The SDK consists of 2 main components:
- Core SDK: This is the actual implementation of all the SDK commands (build, clean, etc.).
- CLI: Command line interface. Parses the command line and calls the Core SDK functions. The CLI is located in `/src/cli`.

## Source Code Structure
- `/src`: Implementation of the core SDK API. Contains error messages and other constant definitions. Each API command is found in either a separate file or a folder (build only):
    - `build`: Folder that holds the implementation files for the 'build' command.
    - `clean.ts`: Implements the 'clean' command. Deletes all files in `node_modules`, `build` and removes `package-lock.json`.
    - `create.ts`: Implements the 'create' command.
    - `info.ts`: Implements the 'info' command.
    - `pack.ts`: Implements the 'pack' command. Pack depends on 'build'.
    - `start.ts`: Implements the 'start' command. Start depends on 'build' and 'server'.
    - `upgrade.ts`: Implements the 'upgrade' command that upgrades a customvis to a newer version. Upgrade depends on 'clean'.
- `/src/cli`: Implementation of the cli. At some point in the future this folder should be moved out of the sdk folder, since it represents only a command line shell around the core-api. No other files in sdk should depend on anything in cli. The cli on the other hand depends on `../index.ts`.
- `src/server`: Http server that hosts a the custom visualization. Used by the 'start' command.
- `src/utils`: Various utility functions used throughout the core SDK.
