import IRSCapability from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSCapability";
/**
 * A capability is used by a rendering service to inform the host about things
 * like data limits or slot limits. Each capability has a name, an optional slot
 * and a set of attributes specific to the capability.
 *
 * This class is only used internally in [[RenderBase]]. There is no need to
 * use this class elsewhere in a custom visualization.
 *
 * @ignore No need to include in typedoc since it is only used internally.
 */
export declare class Capability implements IRSCapability {
    /**
     * Name of the capability.
     */
    name: string;
    /**
     * Name of the slot that the capability applies to.
     */
    slot: string | null;
    /**
     * Optional set of attributes for the capability.
     */
    attributes: Map<string, any>;
    /**
     * @param _name Name of the capability. Currently only "limit" is supported.
     * @param _slot Optional slot name.
     */
    constructor(_name: string, _slot?: string);
    /**
     * Retrieves the name of the capability. Equivalent to `Capability.name`.
     * @ignore
     */
    getName(): string;
    /**
     * Retrieves the slot of the capability. Equivalent to `Capability.slot`.
     * @ignore
     */
    getSlot(): string | null;
    /**
     * Retrieves the attributes of the capability. Equivalent to `Capability.attributes`.
     * @ignore
     */
    getAttributes(): Map<string, object>;
    /**
     * Creates a capability that defines a slot limit.
     * @param _slot Name of a slot.
     * @param _limit Maximum number of tuples on the slot.
     * @returns A new instance of a capability representing the slot limit.
     */
    static slotLimit(_slot: string, _limit: number): Capability;
    /**
     * Creates a capability that defines a data limit.
     * @param _limit Maximum number of data points in the data.
     * @returns A new instance of a capability representing the data limit.
     */
    static dataLimit(_limit: number): Capability;
    /**
     * Provides access to the attributes of a capability.
     * @param _name The name of the attribute to set.
     * @param _value The value of the attribute.
     * @returns The capability instance, to support chaining.
     */
    attr(_name: string, _value: any): this;
}
