/**
 * Represents the reason why rendering should take place. An object of this class is
 * passed in UpdateInfo in a call to [[RenderBase.update]]. The renderer can use the
 * information in this class to optimize rendering. For instance, if only the decorations
 * have changed, the renderer could decide to execute code that only updates the highlight
 * and selection state (rather than rendering the entire visualization).
 */
export declare class RenderReason {
    /**
     * True if the data has changed since the last [[RenderBase.update]].
     */
    readonly data: boolean;
    /**
     * True if one of the decorations (highlight or selected) has changed since
     * the last [[RenderBase.update]].
     */
    readonly decorations: boolean;
    /**
     * True if one of the properties has changed since the last [[RenderBase.update]].
     */
    readonly properties: boolean;
    /**
     * True if the size of the visualization has changed since the last
     * [[RenderBase.update]].
     */
    readonly size: boolean;
    /**
     * @ignore
     */
    constructor(
    /**
     * True if the data has changed since the last [[RenderBase.update]].
     */
    data: boolean, 
    /**
     * True if one of the decorations (highlight or selected) has changed since
     * the last [[RenderBase.update]].
     */
    decorations: boolean, 
    /**
     * True if one of the properties has changed since the last [[RenderBase.update]].
     */
    properties: boolean, 
    /**
     * True if the size of the visualization has changed since the last
     * [[RenderBase.update]].
     */
    size: boolean);
}
