# Customvis-lib

## Source Code
All source code for this project is found in `src`. An `index.ts` is included here to re-export all symbols. This makes using the library convenient since you can do an `import { symbol } from "./src"`.

## Scripts

- **build** - performs a `compile`, `test` and `apidoc`.
- **compile** - runs the typescript compiler on the sources.
- **test** - runs all unit tests and measures code coverage.
- **apidoc** - runs typedoc to generate api reference documentation.
- **watch** - use when developing customvis-lib.

## API Documentation
API reference documentation is created using [Typedoc](https://typedoc.org). The typedoc configuration is found in [typedoc.json](./typedoc.json). This json file is included as a custom tsconfig file because the `tsconfig.json` that is used by customvis-lib has some incompatible options causing `typedoc` to fail.

You can generate a new set of API docs by running:
```
npm run apidoc
```
The API docs are generated in the `docs` folder. Open [docs/index.html](./docs/index.html) to browse the documentation.

The template used for generating API docs is derived from the 'Default' template that was shipped with Typedoc. The template can be found in the [typedoc-theme](./typedoc-theme) folder. Changes (mainly in `.hbs` files) are marked with `CUSTOMVIS:`.

## Unit Tests & Coverage
Unit tests and coverage are performed by Mocha and Nyc. See [test/readme.md](./test/readme.md) for more information on how this was set up.

Run the tests and generate a coverage report by running:
```
npm run test
```
The coverage report is generated in the `coverage` folder. See [coverage/lcov-report/index.html](./coverage/lcov-report/index.html) to check the report.

## Build Output
After a successful build, the Typescript build output can be found in the `lib` folder. You can run a full build using:
```
npm run build
```
This will run a compile, perform all unit tests and generate API docs.
