/**
 * Representation of CSS Length unit values.
 */
export declare enum LengthUnit {
    Em = "em",
    Percentage = "%",
    Centimeter = "cm",
    Millimeter = "mm",
    Inch = "in",
    Pica = "pc",
    Point = "pt",
    Pixel = "px"
}
/**
 * Represents a length value. Length values are returned from properties of type
 * length, and are used to define the size of a [[Font]].
 */
export declare class Length {
    /**
     * The numeric value of the length.
     */
    readonly value: number;
    /**
     * The unit of the length value.
     */
    readonly unit: LengthUnit;
    /**
     * Creates an instance of a length based on a value and unit.
     * @param _value The value of the length.
     * @param _unit The unit of the length.
     */
    constructor(_value: number, _unit: LengthUnit);
    /**
     * Creates a Length instance given an object with a `value` and `unit` attribute.
     * @param _obj An object from which to create a Length instance.
     * @returns A Length instance.
     */
    static fromObject(_obj: {
        value: number;
        unit: string;
    }): Length;
    /**
     * @returns A (CSS compliant) representation of the length.
     */
    toString(): string;
}
