/**
 * RGBA representation of a color. Color instances are returned by [[Properties.get]] when
 * you retrieve the value of a color property. Palette functions also return Color instances.
 */
export declare class Color {
    /**
     * An unsigned byte value (0-255) representing the red channel value.
     */
    readonly r: number;
    /**
     * An unsigned byte value (0-255) representing the green channel value.
     */
    readonly g: number;
    /**
     * An unsigned byte value (0-255) representing the blue channel value.
     */
    readonly b: number;
    /**
     * A double for the alpha value (0-1).
     */
    readonly a: number;
    /**
     * Create a color from red (0-255), green (0-255), blue (0-255) and alpha (0-1) channels.
     * @param _r The red value of the color (0-255).
     * @param _g The green value of the color (0-255).
     * @param _b The blue value of the color (0-255).
     * @param _a The alpha value of the color (0-1).
     */
    constructor(_r: number, _g: number, _b: number, _a: number);
    /**
     * Creates a Color instance given an object with `r`, `g`, `b` and an optional `a` attribute.
     * @param _obj An object from which to create a Color instance.
     * @returns A Color instance.
     *
     * ```typescript
     * // Create a color from an rgb object.
     * const color1 = Color.fromObject( { r: 1, g: 2, b: 3 } );
     *
     * // Clone the first color and change the 'g' value to 20.
     * const color2 = Color.fromObject( { ...color, g: 20 } );
     * ```
     */
    static fromObject(_obj: {
        r: number;
        g: number;
        b: number;
        a?: number;
    }): Color;
    /**
     * @returns An rgb or rbga string representation of the color.
     */
    toString(): string;
}
