import { Length } from "./Length";
/**
 * Representation of CSS Font Style values.
 */
export declare enum FontStyle {
    Normal = "normal",
    Italic = "italic"
}
/**
 * Representation of CSS Font Weight values.
 */
export declare enum FontWeight {
    Thin = 100,
    ExtraLight = 200,
    Light = 300,
    Normal = 400,
    Medium = 500,
    SemiBold = 600,
    Bold = 700,
    ExtraBold = 800,
    Heavy = 900
}
/**
 * Representation of a font with optional family, size, style and weight attributes. Used
 * as a value for font properties. The [[Properties.get]] method returns a Font instance
 * when called with a font property name.
 */
export declare class Font {
    /**
     * The font family collection or `null` if no family is defined.
     */
    readonly family: string[] | null;
    /**
     * The size of the font or `null` if no size is defined.
     */
    readonly size: Length | null;
    /**
     * The font style, for example `normal` or `italic`. Can be `null` if the font does
     * not have a specific style defined.
     */
    readonly style: FontStyle | null;
    /**
     * The font weight value, for example `400` for normal, or `700` for bold. Can be
     * `null` if the font does not have an explicit weight defined.
     */
    readonly weight: number | null;
    /**
     * Creates a read-only instance of a Font. Each one of the attributes is optional.
     * @param _family The font family as an array of strings.
     * @param _size The size of the font.
     * @param _style The style of the font.
     * @param _weight The weight of the font.
     */
    constructor(_family: string[] | null, _size: Length | null, _style: FontStyle | null, _weight: number | null);
    /**
     * Creates a Font instance given an object with optional attributes.
     * @param _obj An object with optional font attributes.
     * @returns A Font object.
     */
    static fromObject(_obj: {
        family?: string[] | null;
        size?: {
            value: number;
            unit: string;
        } | null;
        style?: string | null;
        weight?: number | null;
    }): Font;
    /**
     * @returns A (CSS compliant) representation of the Font.
     */
    toString(): string;
}
