import * as transpile from "./transpile";
/**
 * Creates a bundle from the specified path.
 * @param _path Path in which the bundle resides.
 * @param _transpilerOverrides Additional options that can be used to override the
 * default rollup config.
 * @returns A promise that resolves when the bundle is created.
 */
export declare function createBundle(_path: string, _transpilerOverrides: Partial<transpile.IOverrides>): Promise<void>;
/**
 * Prepare and start watching a bundle, its configs and static files
 * @param _path Root path of the bundle.
 * @param _transpilerOverrides Additional options that can be used to override the
 * default rollup config.
 * @returns A promise that resolves with a function that can be called to stop the
 * watching process.
 */
export declare function watchBundle(_path: string, _transpilerOverrides: Partial<transpile.IOverrides>): Promise<Function>;
