"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const rollup = require("rollup");
function onWarn(_warning, _defaultHandler) {
    // Don't print these to console.log.
    if (_warning.code === "UNRESOLVED_IMPORT" || _warning.code === "UNUSED_EXTERNAL_IMPORT")
        return;
    return _defaultHandler(_warning);
}
/**
 * Runs rollup to build / bundle the sources. Transpiling might be setup by the package.json
 * of the bundle. This will be handled by a rollup plugin (babel).
 * @param _options RollupJS options
 * @returns A promise that resolves with the combined RollupOutput and RollupBuild.
 */
async function rollupTranspile(_options) {
    const bundle = await rollup.rollup(Object.assign(Object.assign({}, _options), { onwarn: onWarn // avoid manually printing to the console by the rollup compiler
     }));
    const output = await bundle.write(_options.output);
    return Object.assign(Object.assign({}, bundle), output);
}
exports.rollupTranspile = rollupTranspile;
