import { RollupOptions } from "rollup";
import { FSWatcher } from "chokidar";
export interface IOverrides extends RollupOptions {
}
/**
 * Transpile the sources. Transpiling is the process of building the code for the bundle
 * into the build folder. Next to generating / copying vizdef and manifest this is part
 * of the build process.
 * @param _path Root path of the bundle.
 * @param _rollupOverrides Rollup config overrides.
 * @returns A promise that resolves when the sources are transpiled.
 */
export declare function transpile(_path: string, _rollupOverrides: Partial<IOverrides>): Promise<void>;
/**
 * Start watching and transpile the sources on change.
 * @param _path Root path of the bundle.
 * @param _rollupOverrides Rollup config overrides.
 * @returns A promise that resolves with a file watcher instance. Callers can use this
 * instance to subscribe to events or to stop watching.
 */
export declare function watch(_path: string, _rollupOverrides: Partial<IOverrides>): Promise<FSWatcher>;
/**
 * Generate a rollup template. A rollup template is basically a rollup config file
 * that holds the default set of rollup options. The getRollupOptions function, used
 * in transpile and watch, reads this file and allows overriding specific options.
 * @param _path The location where to create the rollup template. Typically the
 * root path of a bundle.
 * @returns A promise that resolves when the template has been generated.
 */
export declare function generateRollupTemplate(_path: string): Promise<void>;
/**
 * Add rollup (dev-)dependencies to a bundle by merging the existing devDependencies
 * with the set of dependencies found in sdk's static/rollup-dependencies.json.
 * @param _path The path of a bundle.
 * @returns A promise that resolves when the function is done updating package.json.
 * The promise resolves with true if the file has changed, or false if the file was
 * left unchanged.
 */
export declare function addDevDependenciesToPackage(_path: string): Promise<boolean>;
