export interface ITSProgram {
    /**
     * Validate a given typescript file for errors.
     * @param _entryFile The typescript file that should be validated.
     * @returns A promise that resolves when the file is validated. The promise is
     * rejected with an error if validation fails.
     */
    typeCheck(_entryFile: string): Promise<void>;
}
/**
 * Create a typescript program using ts-node. Used by 'transpile.ts'.
 * @param _rootPath the root path of the typescript project.
 * @returns An object with a 'typeCheck' function that can be called to perform
 * typescript validation on a file.
 */
export declare function createTypescriptProgram(_rootPath: string): ITSProgram;
