"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("./utils/fs");
const path = require("path");
const constants_1 = require("./constants");
/**
 * Perform a cleanup of a bundle. Cleanup means removing all files that were generated
 * or installed by the sdk.
 * @param _currentPath The path where the bundle is located.
 * @returns A promise that resolves when all files are cleaned.
 */
async function clean(_path) {
    await Promise.all(constants_1.IGNORED_FILES.map(_file => fs.remove(path.join(_path, _file))));
}
exports.clean = clean;
