#!/usr/bin/env node
"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const program = require("commander");
const bundler = require("..");
const index_1 = require("./index");
const logging_1 = require("./logging");
// Require root package json to figure out program version.
const packageJson = require("../../package.json");
const currentPath = process.cwd();
program.version(packageJson.version);
program.command("create <name>")
    .alias("c")
    .description("Create a new custom visualization with <name>")
    .option("-f, --force", "Force folder creation")
    .option("-t, --template <template>", "Create new project from <template>")
    .action(index_1.create(currentPath));
program.command("list")
    .alias("l")
    .description("List all templates which can be used for a new visualization")
    .action(index_1.list());
program.command("start")
    .alias("s")
    .description("Build and start a local server hosting the current visualization")
    .option("-p, --port <port>", `Use localhost:<port>`, bundler.DEFAULT_PORT)
    .action(index_1.start(currentPath));
program.command("pack")
    .alias("p")
    .description("Pack the current visualization")
    .action(index_1.pack(currentPath));
program.command("build")
    .alias("b")
    .description("Build the current visualization")
    .action(index_1.build(currentPath));
program.command("clean")
    .alias("cl")
    .description("Cleans the current visualization")
    .action(index_1.clean(currentPath));
program.command("upgrade")
    .alias("up")
    .description("Upgrade the customvis-lib in the current visualization")
    .action(index_1.upgrade(currentPath));
program.command("info")
    .alias("i")
    .description("Get information about the CLI tool & current visualization")
    .action(index_1.info(currentPath));
// Handle invalid commands.
program.on("command:*", () => {
    console.error("Invalid command");
    program.help(); // calling help will also terminate the process
});
logging_1.registerEvents();
program.parse(process.argv);
// Show help if no args are supplied.
if (program.args.length === 0)
    program.help();
