"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const constants = require("./constants");
const childProcess = require("child_process");
const events_1 = require("./utils/events");
/**
 * Install dependencies in the specified path.
 * @param _path The path where package.json is located.
 * @returns A promise that resolves when all dependencies have been installed.
 */
async function installDependencies(_path) {
    events_1.emitEvent(constants.BUILDER_EVENTS.INSTALLING_DEPENDENCIES);
    await new Promise((_resolve, _reject) => {
        childProcess.exec("npm install", { cwd: _path }, _err => {
            if (_err)
                _reject(_err);
            else
                _resolve();
        });
    });
}
exports.installDependencies = installDependencies;
