"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LIB_PACKAGE_NAME = "@businessanalytics/customvis-lib";
exports.LIB_PACKAGE_PATH = `node_modules/${exports.LIB_PACKAGE_NAME}`;
exports.LIB_PACKGE_FILE_IN_VIS = "customvis-lib.tgz";
exports.D3_EXTERNAL_LINK = "https://d3js.org/d3.v5.min.js";
exports.DEFAULT_TEMPLATE = "Basic";
exports.IGNORED_FILES = ["node_modules", "package-lock.json", "build"];
exports.OUTPUT_DIR = "build";
exports.DEFAULT_PORT = 8585;
exports.STATIC_FILES = ["./static", "./nls", "icon.svg"];
exports.ROLLUP_CONFIG = "rollup.config.js";
exports.ROLLUP_DEPS = "rollup-dependencies.json";
exports.BUILDER_EVENT = "BUILDER_EVENT";
exports.BUILDER_ERROR = "BUILDER_ERROR";
var BUILDER_EVENTS;
(function (BUILDER_EVENTS) {
    // common
    BUILDER_EVENTS[BUILDER_EVENTS["CREATING_NEW_PROJECT"] = 0] = "CREATING_NEW_PROJECT";
    BUILDER_EVENTS[BUILDER_EVENTS["DONE_CREATING_PROJECT"] = 1] = "DONE_CREATING_PROJECT";
    BUILDER_EVENTS[BUILDER_EVENTS["START_UPGRADING_LIB"] = 2] = "START_UPGRADING_LIB";
    BUILDER_EVENTS[BUILDER_EVENTS["DONE_UPGRADING_LIB"] = 3] = "DONE_UPGRADING_LIB";
    BUILDER_EVENTS[BUILDER_EVENTS["INSTALLING_DEPENDENCIES"] = 4] = "INSTALLING_DEPENDENCIES";
    // server related
    BUILDER_EVENTS[BUILDER_EVENTS["SERVER_STARTING"] = 5] = "SERVER_STARTING";
    BUILDER_EVENTS[BUILDER_EVENTS["SERVER_STARTED"] = 6] = "SERVER_STARTED";
    BUILDER_EVENTS[BUILDER_EVENTS["SERVER_STOPPED"] = 7] = "SERVER_STOPPED";
    // builder
    BUILDER_EVENTS[BUILDER_EVENTS["GENERATING_VIZDEF"] = 8] = "GENERATING_VIZDEF";
    BUILDER_EVENTS[BUILDER_EVENTS["GENERATING_MANIFEST"] = 9] = "GENERATING_MANIFEST";
    BUILDER_EVENTS[BUILDER_EVENTS["GENERATING_META"] = 10] = "GENERATING_META";
    BUILDER_EVENTS[BUILDER_EVENTS["START_BUILDING"] = 11] = "START_BUILDING";
    BUILDER_EVENTS[BUILDER_EVENTS["DONE_BUILDING"] = 12] = "DONE_BUILDING";
    BUILDER_EVENTS[BUILDER_EVENTS["START_WATCHING"] = 13] = "START_WATCHING";
    BUILDER_EVENTS[BUILDER_EVENTS["STOPPED_WATCHING"] = 14] = "STOPPED_WATCHING";
    BUILDER_EVENTS[BUILDER_EVENTS["START_PACKING"] = 15] = "START_PACKING";
    BUILDER_EVENTS[BUILDER_EVENTS["START_ZIPPING"] = 16] = "START_ZIPPING";
    BUILDER_EVENTS[BUILDER_EVENTS["DONE_ZIPPING"] = 17] = "DONE_ZIPPING";
    BUILDER_EVENTS[BUILDER_EVENTS["DONE_PACKING"] = 18] = "DONE_PACKING";
    // compiler
    BUILDER_EVENTS[BUILDER_EVENTS["START_TRANSPILING"] = 19] = "START_TRANSPILING";
    BUILDER_EVENTS[BUILDER_EVENTS["DONE_TRANSPILING"] = 20] = "DONE_TRANSPILING";
})(BUILDER_EVENTS = exports.BUILDER_EVENTS || (exports.BUILDER_EVENTS = {}));
