/**
 * Creation options.
 */
export interface ICreateOptions {
    /**
     * Flag to force creation of the bundle even if a folder with the same name
     * alread exists. Defaults to false.
     */
    force: boolean;
    /**
     * Name of the template to use for creating a new bundle. Defaults to 'Basic'.
     */
    template: string;
}
/**
 * Creates a new bundle from a template
 * @param _path the current path where the new bundle should be created in
 * @param _name the name of the new bundle, the name will be used for folder creation
 * @param _options additional options which can be used
 */
export declare function create(_path: string, _name: string, _options?: Partial<ICreateOptions>): Promise<string>;
