"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
exports.NO_VIZDEF_ERROR = "No vizdef found! Is this a valid project?";
exports.INVALID_VIZDEF_FORMAT = "vizdef.xml has invalid XML format";
exports.INVALID_MANIFEST_FORMAT = "Could not validate manifest";
exports.INVALID_MANIFEST_META_NAME = "Bundle-Name in manifest is not the same as 'meta.name' in package.json";
exports.INVALID_MANIFEST_META_ID = "Bundle-SymbolicName in manifest is not the same as 'meta.id' in package.json";
exports.PACKAGE_NO_META_INFO = "package.json does not have meta information";
exports.PACKAGE_NO_META_NAME = "package.json does not contain a 'meta.name' property";
exports.PACKAGE_NO_META_ID = "package.json does not contain a 'meta.id' property";
exports.PACKAGE_NO_META_TYPE = "package.json does not contain a 'meta.type' property or has invalid type";
exports.INVALID_DEV_VIS = "This is not a valid development visualization";
exports.createInvalidFolderError = (_destination) => `Folder ${_destination} already exists, if you want to override, use the -f flag or choose a different name.`;
exports.createInvalidTemplateError = (_template) => `The given template "${_template}" is not a valid template. Use "customvis list" command to list all available templates.`;
exports.SERVER_INVALID_PATH = "invalid path";
exports.SERVER_INVALID_URL = "invalid url";
exports.createFailedToZipError = (_target) => `Failed to zip ${_target}`;
exports.UPGRADE_NO_VIZDEF = "No vizdef found! Please use the customvis bundle sources to upgrade.";
exports.UPGRADE_PACKED_ERROR = "It is not possible to upgrade a packed customvis. Please use the customvis sources to upgrade.";
exports.createUpgradeInstallDepError = (_reason) => `NPM install failed. \n\n${_reason}. \n\nPlease try to manually execute 'npm install' and run "start" command`;
exports.NO_ROLLUP_CONFIG = "No rollup.config.js found! Try to run \"customvis clean\" first";
