/**
 * Version information, used as the return value for the upgrade function.
 */
export interface IUpgradeResult {
    /**
     * Previous version of customvis-lib, or unknown if a previous version
     * could not be determined.
     */
    oldVersion?: string;
    /**
     * New version of customvis-lib.
     */
    currentVersion: string;
    /**
     * Path of the bundle that was upgraded.
     */
    path: string;
}
/**
 * Upgrade the customvis-lib of the bundle. Effectively this performs a 'clean'
 * followed by a copy of a new customvis-lib and a dependencies install.
 * @param _path The absolute path where the bundle is located.
 */
export declare function upgrade(_path: string): Promise<IUpgradeResult>;
