/**
 * Represents the configuration of a bundle, derived from the bundle's package.json.
 */
export interface IConfig {
    /**
     * Human readable name of the bundle.
     */
    name: string;
    /**
     * Symbolic (unique) name of the bundle.
     */
    symbolicName: string;
    /**
     * Type of the bundle, always 'renderer' for customvis.
     */
    type: string;
    /**
     * Version of the manifest file, currently always '1.0'.
     */
    manifestVersion: string;
    /**
     * Description of the bundle.
     */
    description: string;
    /**
     * Version of the bundle.
     */
    version: string;
    /**
     * Version of the rendering service API.
     */
    apiVersion: string;
    /**
     * Optional location of an icon to be associated with the bundle.
     */
    icon?: string;
}
/**
 * Get the config that is determined from package.json.
 * @param _path Path of the bundle.
 */
export declare function getConfig(_path: string): Promise<IConfig>;
