/// <reference types="node" />
import { EventEmitter } from "events";
import { BUILDER_EVENTS, BUILDER_ERROR_EVENTS } from "../constants";
/**
 * Emit a builder event. Listeners (logging.ts) can subscribe to the event.
 * @param _ev One of the builder event enum values.
 * @param args Arguments to be passed to the event.
 */
export declare function emitEvent(_ev: BUILDER_EVENTS, ...args: any[]): void;
/**
 * Emit a builder error event. Listeners (logging.ts) can subscribe to the event.
 * @param _errEv One of the builder error enum values.
 * @param args Arguments to be passed to the event.
 */
export declare function emitError(_errEv: BUILDER_ERROR_EVENTS, ...args: any[]): void;
/**
 * Retrieve the EventEmitter singleton. Call this function to subscribe to events
 * of this emitter. Typically you want to listen to events of type BUILDER_EVENT
 * or BUILDER_ERROR.
 * @returns The EventEmitter singleton.
 */
export declare function getEventEmitter(): EventEmitter;
