"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const constants_1 = require("../constants");
/**
 * Emit a builder event. Listeners (logging.ts) can subscribe to the event.
 * @param _ev One of the builder event enum values.
 * @param args Arguments to be passed to the event.
 */
function emitEvent(_ev, ...args) {
    getEventEmitter().emit(constants_1.BUILDER_EVENT, _ev, ...args);
}
exports.emitEvent = emitEvent;
/**
 * Emit a builder error event. Listeners (logging.ts) can subscribe to the event.
 * @param _errEv One of the builder error enum values.
 * @param args Arguments to be passed to the event.
 */
function emitError(_errEv, ...args) {
    getEventEmitter().emit(constants_1.BUILDER_ERROR, _errEv, ...args);
}
exports.emitError = emitError;
let eventEmitter; // use only one EventEmitter
/**
 * Retrieve the EventEmitter singleton. Call this function to subscribe to events
 * of this emitter. Typically you want to listen to events of type BUILDER_EVENT
 * or BUILDER_ERROR.
 * @returns The EventEmitter singleton.
 */
function getEventEmitter() {
    if (!eventEmitter)
        eventEmitter = new events_1.EventEmitter();
    return eventEmitter;
}
exports.getEventEmitter = getEventEmitter;
