"use strict";
// Licensed Materials - Property of IBM
//
// IBM Watson Analytics
//
// (C) Copyright IBM Corp. 2019, 2020
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const fs = require("./fs");
const path = require("path");
/**
 * Retrieve the full path of a named template. If no template name is specified, the
 * path of the default template (Basic) is returned.
 * @param _template Name of a template (e.g. Basic)
 * @returns Full path of the template.
 */
function getTemplatePath(_template = constants_1.DEFAULT_TEMPLATE) {
    return path.join(fs.getTemplatePath(), _template);
}
exports.getTemplatePath = getTemplatePath;
/**
 * Returns a list of available templates. The list contains only the template names.
 * If you want to get the full path of a template, call `getTemplatePath`.
 * @returns A list of available template names.
 */
async function getTemplates() {
    return fs.readdir(fs.getTemplatePath());
}
exports.getTemplates = getTemplates;
