import IRSDecorated from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/data/IRSDecorated";
import IRSFormatter from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/data/IRSFormatter";
/**
 * This module holds functions that are needed for compatibility with the rendering
 * service interfaces. Until all interfaces can be correctly translated from VIPR-RS,
 * some manual type conversion and interface checks might need to take place.
 *
 * Ideally this file should not exist...
 */
/**
 * Allows passing `any` as the default value and getting an `any` value as the return
 * value. TypeScript generator does not support this yet.
 * @param _source Source object
 * @param _name Name of the decoration
 * @param _default Default value of the decoration
 * @returns Value of the decoration, or the specified default value.
 * @ignore
 */
export declare function getDecoration(_source: IRSDecorated, _name: string, _default: any): any;
/**
 * Use a formatter to format the specified value. Allows passing simple types as values.
 * @param _formatter The formatter to use.
 * @param _value The value to format.
 * @returns The formatted value.
 * @ignore
 */
export declare function formatValue(_formatter: IRSFormatter, _value: any): string;
