/**
 * The MetaInfo class holds meta information for the visualization. The [[RenderBase]] class
 * owns an instance of MetaInfo and Subclasses are allowed to access and change attributes.
 * See [[RenderBase.meta]] for more information and some sample code.
 */
export declare class MetaInfo {
    /**
     * Shape of elements in a categorical (swatch) legend. Possible values are `circle`,
     * `rectangle`, `square`, `triangle`, `cross`, `donut`, `line`, `diamond`, `star`,
     * `triangle-down`, `triangle-up`, `triangle-left` or `triangle-right`.
     * Can also be null to indicate that the host should use a default shape or the
     * string `none` to indicate that no shape should be displayed.
     */
    legendShape: string | null;
    /**
     * Slot limits define the number of supported tuples in a slot. Implemented as a
     * map from 'slot name' to 'limit value'. If you don't want the limit the slot,
     * remove the slot name from the map or set its value to -1.
     */
    slotLimits: Map<string, number>;
    /**
     * Data limit defines the maximum number of data points the visualization supports.
     * Can be set to -1 to indicate there is no limit.
     */
    dataLimit: number;
}
