import IRSEncoding from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSEncoding";
import IRSCatEncoding from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSCatEncoding";
import IRSCatEncodingEntry from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSCatEncodingEntry";
import IRSContEncoding from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSContEncoding";
import IRSColor from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSColor";
import IRSColorStop from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/IRSColorStop";
import IRSContDomain from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/data/IRSContDomain";
import IRSDataNode from "@waca/vipr-rs-v1/com/ibm/vipr/rs/v1/data/IRSDataNode";
import { DataSet, Slot } from "./Data";
import { Properties } from "./Properties";
import { CatPalette, ContPalette } from "./Palettes";
import { MetaInfo } from "./MetaInfo";
import { SlotResolver } from "./SlotResolver";
import { Color } from "./Color";
/**
 * Implementation of a categorical encoding entry. Used at construction time by
 * the [[CatEncoding]] class when encoding entries are created for each tuple
 * found on a particular slot.
 */
export declare class CatEncodingEntry implements IRSCatEncodingEntry {
    caption: string;
    color: Color | null;
    shape: string | null;
    selected: boolean;
    highlighted: boolean;
    ref: IRSDataNode | null;
    /**
     * Creates an encoding entry for use in a CatEncoding.
     * @param caption Caption of the entry.
     * @param color Optional color of the entry.
     * @param shape Shape of the entry.
     * @param selected Selection status.
     * @param highlighted Highlight status.
     * @param ref Reference to an underlying data object.
     * @ignore
     */
    constructor(caption: string, color: Color | null, shape: string | null, selected: boolean, highlighted: boolean, ref: IRSDataNode | null);
    /**
     * Retrieves the caption of the entry. Equivalent to `CatEncodingEntry.caption`.
     * @ignore
     */
    getCaption(): string;
    /**
     * Retrieves the color of the entry as an IRSColor.
     * @ignore
     */
    getColor(): IRSColor | null;
    /**
     * Retrieves the shape of the entry. Equivalent to `CatEncodingEntry.shape`.
     * @ignore
     */
    getShape(): string | null;
    /**
     * Retrieves the selected state of the entry. Equivalent to `CatEncodingEntry.selected`.
     * @ignore
     */
    isSelected(): boolean;
    /**
     * Retrieves the highlight state of the entry. Equivalent to `CatEncodingEntry.highlighted`.
     * @ignore
     */
    isHighlighted(): boolean;
    /**
     * Retrieves the ref object of the entry. Equivalent to `CatEncodingEntry.ref`.
     * @ignore
     */
    getRef(): IRSDataNode | null;
}
/**
 * Encoding base class. Subclassed by [[CatEncoding]] and [[ContEncoding]]. If you
 * are going to override [[RenderBase.updateLegend]], then you are expected to return
 * an array of `Encoding` instances. Each encoding represents a legend group.
 */
export declare abstract class Encoding implements IRSEncoding {
    /**
     * The type of the encoding, either "cat" or "cont".
     */
    type: string;
    /**
     * The encoding channel. Can be either "color" or "size"
     */
    channel: string;
    /**
     * The slot that this encoding is assigned to.
     */
    slot: string | null;
    /**
     * The caption for the encoding. Will be rendered as the legend group caption.
     */
    caption: string;
    /**
     * An optional sub caption for the encoding.
     */
    subCaption: string;
    /**
     * An optional data object that is referenced by this encoding.
     */
    ref: IRSDataNode | null;
    /**
     * @ignore
     */
    protected constructor(
    /**
     * The type of the encoding, either "cat" or "cont".
     */
    type: string, 
    /**
     * The encoding channel. Can be either "color" or "size"
     */
    channel: string, 
    /**
     * The slot that this encoding is assigned to.
     */
    slot: string | null, 
    /**
     * The caption for the encoding. Will be rendered as the legend group caption.
     */
    caption: string, 
    /**
     * An optional sub caption for the encoding.
     */
    subCaption: string, 
    /**
     * An optional data object that is referenced by this encoding.
     */
    ref: IRSDataNode | null);
    /**
     * Retrieves the type of the encoding. Equivalent to `Encoding.type`.
     * @ignore
     */
    getRSType(): string;
    /**
     * Retrieves the channel of the encoding. Equivalent to `Encoding.channel`.
     * @ignore
     */
    getChannel(): string;
    /**
     * Retrieves the slot name of the encoding. Equivalent to `Encoding.slot`.
     * @ignore
     */
    getSlot(): string | null;
    /**
     * Retrieves the caption of the encoding. Equivalent to `Encoding.caption`.
     * @ignore
     */
    getCaption(): string;
    /**
     * Retrieves the sub caption of the encoding. Equivalent to `Encoding.subCaption`.
     * @ignore
     */
    getSubCaption(): string;
    /**
     * Retrieves the ref object of the encoding. Equivalent to `Encoding.ref`.
     * @ignore
     */
    getRef(): IRSDataNode | null;
}
/**
 * Categorical encoding. Instance can be created given a slot, palette and some
 * meta information. Instances of CatEncoding can be returned to a host for
 * creating (swatch) legends.
 */
export declare class CatEncoding extends Encoding implements IRSCatEncoding {
    entries: CatEncodingEntry[];
    /**
     * A CatEncoding instance is used to render a categorical legend group.
     * @param _channel The encoding channel. Only "color" is currently supported.
     * @param _slot A slot for this encoding.
     * @param _caption The caption for the legend group.
     * @param _shape A shape that will be used for every entry in the group.
     * @param _palette A palette that is used to determine entry colors.
     * @ignore
     */
    constructor(_channel: string, _slot: Slot | null, _caption: string, _shape: string | null, _palette: CatPalette | null);
    /**
     * Retrieves the entries of the encoding. Equivalent to `CatEncoding.entries`.
     * @ignore
     */
    getEntries(): CatEncodingEntry[];
}
/**
 * Continuous encoding. Instances can be created given a slot, palette and some
 * meta information. Instances of RSContEncoding can be returned to a host for
 * creating (size or heat) legends.
 * Note: The slot passed to the constructor must be mapped!
 */
export declare class ContEncoding extends Encoding implements IRSContEncoding {
    domain: IRSContDomain;
    interpolate: boolean;
    stops: IRSColorStop[] | null;
    /**
     * A ContEncoding instance is used to render a continuous legend group.
     * @param _channel The encoding channel. Only "color" is currently supported.
     * @param _slot The slot for this encoding. **The slot must be mapped!**
     * @param _caption The caption for the legend group.
     * @param _palette A palette that is used to determine entry colors.
     * @ignore
     */
    constructor(_channel: string, _slot: Slot | null, _caption: string, _palette: ContPalette | null);
    /**
     * Retrieves the domain of the encoding. Equivalent to `ContEncoding.domain`.
     * @ignore
     */
    getDomain(): IRSContDomain;
    /**
     * Retrieves the interpolate state of the encoding. Equivalent to `ContEncoding.interpolate`.
     * @ignore
     */
    getInterpolate(): boolean;
    /**
     * Retrieves the stops of the encoding. Equivalent to `ContEncoding.stops`.
     * @ignore
     */
    getStops(): IRSColorStop[] | null;
}
/**
 * Produces encodings based on data and properties. The encodings created by this class
 * can be returned to a host for drawing legends. This function is used internally by
 * the `RenderBase` class to provide out of the box legend support.
 * @param _data Rendering service data.
 * @param _props Properties of the visualization.
 * @param _meta Meta information about the visualization.
 * @param _map Map of dynamically linked palettes.
 * @returns An array of legend encodings that can be returned to VIPR. Encodings returned
 * by this function are instances of Legend.CatEncoding or Legend.ContEncoding.
 * @ignore
 */
export declare function createEncodings(_data: DataSet | null, _props: Properties, _meta: MetaInfo, _cb: SlotResolver): Encoding[];
