import { RenderReason } from "./RenderReason";
import { DataSet } from "./Data";
import { Properties } from "./Properties";
/**
 * Holds state information that can be used during a [[RenderBase.update]] operation.
 * Allows you to access data, properties and the DOM node for rendering the visualization.
 */
export declare class UpdateInfo {
    /**
     * The reason why rendering should take place. Check the flags in this object
     * to see which aspects of the visualization need rendering.
     */
    readonly reason: RenderReason;
    /**
     * The data that should be rendered, or null if there is no data.
     */
    readonly data: DataSet | null;
    /**
     * The HTML element on which rendering should take place. This is the element
     * that was returned previously from a the [[RenderBase.create]] method.
     */
    readonly node: Element;
    /**
     * The current set of properties. Properties can also be accessed through the
     * [[RenderBase.properties]] attribute.
     */
    readonly props: Properties;
    /**
     * The data locale that should be used for rendering. Should not be used for
     * translations, only for custom data formatting where that is necessary.
     */
    readonly locale: string;
    /**
     * @ignore
     */
    constructor(
    /**
     * The reason why rendering should take place. Check the flags in this object
     * to see which aspects of the visualization need rendering.
     */
    reason: RenderReason, 
    /**
     * The data that should be rendered, or null if there is no data.
     */
    data: DataSet | null, 
    /**
     * The HTML element on which rendering should take place. This is the element
     * that was returned previously from a the [[RenderBase.create]] method.
     */
    node: Element, 
    /**
     * The current set of properties. Properties can also be accessed through the
     * [[RenderBase.properties]] attribute.
     */
    props: Properties, 
    /**
     * The data locale that should be used for rendering. Should not be used for
     * translations, only for custom data formatting where that is necessary.
     */
    locale: string);
}
