/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.timedoperations;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.timedoperations.internal.TimedOperationImpl;
import com.ibm.wsspi.timedoperations.LRUCache;
import com.ibm.wsspi.timedoperations.TimedOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimedOperationService {
    private static final String TIMED_OPERATION_AUTO_CLEANUP_FLAG = "com.ibm.timedOperations.autoCleanup";
    private static boolean timedOperationAutoCleanupRequired = System.getenv("com.ibm.timedOperations.autoCleanup") != null ? Boolean.parseBoolean(System.getenv("com.ibm.timedOperations.autoCleanup")) : true;
    private static boolean timedOperationAutoCleanupWarningProvided = false;
    private static boolean enabled = false;
    private static final TraceComponent tc = Tr.register(TimedOperationService.class);
    private static int maxNumberTimedOperations = 10000;
    private static Object timedOperationsLock = new Object();
    private static Map<String, TimedOperation> timedOperations = timedOperationAutoCleanupRequired ? new LRUCache(maxNumberTimedOperations) : new HashMap();
    private static boolean enableReport = true;
    private static int reportFrequency = 24;
    private static final String PROPERTY_MAX_NUMBER = "maxNumberTimedOperations";
    private static final String PROPERTY_ENABLE_REPORT = "enableReport";
    private static final String PROPERTY_REPORT_FREQUENCY = "reportFrequency";
    static Map<String, Object> explicitConfiguration;
    private ScheduledExecutorService executorService = null;
    private ScheduledFuture<?> timeKeeper = null;
    static final Object syncTimerStartObject;
    final Runnable generateReport = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            HashMap<String, ArrayList<TimedOperation>> timedOperationsByType = TimedOperationService.getTimedOperationsByType();
            for (Map.Entry<String, ArrayList<TimedOperation>> crtEntry : timedOperationsByType.entrySet()) {
                int timedOperationsSize;
                ArrayList<TimedOperation> toSortedList = crtEntry.getValue();
                Tr.info((TraceComponent)tc, (String)"TIMED_OPERATION_REPORT_ENTRY_MSG", (Object[])new Object[0]);
                for (int i = 0; i < Math.min(10, toSortedList.size()); ++i) {
                    Tr.info((TraceComponent)tc, (String)"TIMED_OPERATION_REPORT_MSG", (Object[])new Object[]{toSortedList.get(i).getId(), ((TimedOperationImpl)toSortedList.get(i)).getRule().getExpectedDuration()});
                }
                Object object = timedOperationsLock;
                synchronized (object) {
                    timedOperationsSize = timedOperations.size();
                }
                Tr.info((TraceComponent)tc, (String)"TIMED_OPERATION_REPORT_EXIT_MSG", (Object[])new Object[]{timedOperationsSize});
                if (timedOperationsSize <= TimedOperationService.getMaxNumberTimedOperations()) continue;
                Tr.warning((TraceComponent)tc, (String)"TIMED_OPERATION_MAX_NUMBER_EXCEEDED", (Object[])new Object[]{timedOperationsSize, TimedOperationService.getMaxNumberTimedOperations()});
            }
        }
    };

    protected void activate(Map<String, Object> configuration) {
        TimedOperationService.setExplicitConfiguration(configuration);
        TimedOperationService.configureService();
        if (this.executorService != null && TimedOperationService.isReportEnabled()) {
            this.timeKeeper = this.executorService.scheduleAtFixedRate(this.generateReport, 1L, TimedOperationService.getReportFrequency(), TimeUnit.HOURS);
        }
    }

    protected void deactivate() {
        TimedOperationService.setExplicitConfiguration(null);
        enabled = false;
    }

    protected static Map<String, Object> getExplicitConfiguration() {
        return explicitConfiguration;
    }

    protected static void setExplicitConfiguration(Map<String, Object> configuration) {
        explicitConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modified(Map<String, Object> configuration) {
        explicitConfiguration = configuration;
        int oldReportFrequency = reportFrequency;
        boolean reportFrequencySet = false;
        for (Map.Entry<String, Object> configElem : configuration.entrySet()) {
            String configKey = configElem.getKey();
            Object configValue = configElem.getValue();
            if (configKey.compareTo(PROPERTY_MAX_NUMBER) == 0) {
                maxNumberTimedOperations = (Integer)configValue;
            }
            if (configKey.compareTo(PROPERTY_ENABLE_REPORT) == 0) {
                enableReport = (Boolean)configValue;
            }
            if (configKey.compareTo(PROPERTY_REPORT_FREQUENCY) != 0) continue;
            reportFrequency = ((Long)configValue).intValue();
            reportFrequencySet = true;
        }
        if (!reportFrequencySet) {
            reportFrequency = 24;
        }
        if (timedOperationAutoCleanupRequired) {
            Object object = timedOperationsLock;
            synchronized (object) {
                if (timedOperations.size() > maxNumberTimedOperations) {
                    LRUCache newTimedOperations = new LRUCache(maxNumberTimedOperations);
                    newTimedOperations.putAll(timedOperations);
                    timedOperations = newTimedOperations;
                }
            }
        }
        if (enableReport) {
            if (this.timeKeeper != null) {
                if (reportFrequency != oldReportFrequency) {
                    this.timeKeeper.cancel(false);
                    this.timeKeeper = this.executorService != null ? this.executorService.scheduleAtFixedRate(this.generateReport, 1L, reportFrequency, TimeUnit.HOURS) : null;
                }
            } else if (this.executorService != null) {
                this.timeKeeper = this.executorService.scheduleAtFixedRate(this.generateReport, 1L, reportFrequency, TimeUnit.HOURS);
            }
        } else if (this.timeKeeper != null) {
            this.timeKeeper.cancel(false);
            this.timeKeeper = null;
        }
    }

    protected void setScheduledExecutor(ScheduledExecutorService ref) {
        this.executorService = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetScheduledExecutor(ScheduledExecutorService ref) {
        if (ref == this.executorService) {
            Object object = syncTimerStartObject;
            synchronized (object) {
                if (this.timeKeeper != null) {
                    this.timeKeeper.cancel(false);
                    this.timeKeeper = null;
                }
            }
            this.executorService = null;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static int getMaxNumberTimedOperations() {
        return maxNumberTimedOperations;
    }

    public static boolean isReportEnabled() {
        return enableReport;
    }

    public static int getReportFrequency() {
        return reportFrequency;
    }

    private static void configureService() {
        enabled = true;
        Map<String, Object> configMap = TimedOperationService.getExplicitConfiguration();
        Set<Map.Entry<String, Object>> configSet = configMap.entrySet();
        for (Map.Entry<String, Object> configElem : configSet) {
            String configKey = configElem.getKey();
            Object configValue = configElem.getValue();
            if (configKey.compareTo(PROPERTY_MAX_NUMBER) == 0) {
                maxNumberTimedOperations = (Integer)configValue;
            }
            if (configKey.compareTo(PROPERTY_ENABLE_REPORT) == 0) {
                enableReport = (Boolean)configValue;
            }
            if (configKey.compareTo(PROPERTY_REPORT_FREQUENCY) != 0) continue;
            reportFrequency = ((Long)configValue).intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimedOperation getTimedOperation(String type, String pattern) {
        TimedOperation timedOp;
        Object object = timedOperationsLock;
        synchronized (object) {
            TimedOperation timedOperationConfig = TimedOperationService.findTimedOperation(type, pattern);
            if (timedOperationConfig != null) {
                timedOp = timedOperationConfig;
            } else {
                timedOp = new TimedOperationImpl(type, pattern);
                if (timedOperations.size() == TimedOperationService.getMaxNumberTimedOperations()) {
                    if (timedOperationAutoCleanupRequired) {
                        if (!timedOperationAutoCleanupWarningProvided) {
                            Tr.warning((TraceComponent)tc, (String)"TIMED_OPERATION_MAX_NUMBER_EXCEEDED_CLEANUP_INFO", (Object[])new Object[]{timedOperations.size()});
                            timedOperationAutoCleanupWarningProvided = true;
                        }
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"TIMED_OPERATION_MAX_NUMBER_EXCEEDED", (Object[])new Object[]{timedOperations.size(), TimedOperationService.getMaxNumberTimedOperations()});
                    }
                }
                timedOperations.put(timedOp.getId(), timedOp);
            }
        }
        return timedOp;
    }

    private static TimedOperation findTimedOperation(String type, String pattern) {
        String timedOperationId = null;
        timedOperationId = pattern != null ? type + ":" + pattern : type;
        return timedOperations.get(timedOperationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<TimedOperation> getTimedOperations() {
        Object object = timedOperationsLock;
        synchronized (object) {
            return timedOperations.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, ArrayList<TimedOperation>> getTimedOperationsByType() {
        Collection<TimedOperation> timedOperationsList;
        Object object = timedOperationsLock;
        synchronized (object) {
            timedOperationsList = timedOperations.values();
        }
        HashMap<String, ArrayList<TimedOperation>> timedOperationsByTypeList = new HashMap<String, ArrayList<TimedOperation>>();
        HashMap<String, ArrayList<TimedOperation>> timedOperationsByType = TimedOperationService.sortTimedOperationsByType(timedOperationsList);
        for (Map.Entry<String, ArrayList<TimedOperation>> crtElem : timedOperationsByType.entrySet()) {
            String crtType = crtElem.getKey();
            ArrayList<TimedOperation> toSortedList = crtElem.getValue();
            Collections.sort(toSortedList, new Comparator<TimedOperation>(){

                @Override
                public int compare(TimedOperation to1, TimedOperation to2) {
                    return ((TimedOperationImpl)to1).getRule().getExpectedDuration() < ((TimedOperationImpl)to2).getRule().getExpectedDuration() ? 1 : (((TimedOperationImpl)to1).getRule().getExpectedDuration() == ((TimedOperationImpl)to2).getRule().getExpectedDuration() ? 0 : -1);
                }
            });
            timedOperationsByTypeList.put(crtType, toSortedList);
        }
        return timedOperationsByTypeList;
    }

    private static HashMap<String, ArrayList<TimedOperation>> sortTimedOperationsByType(Collection<TimedOperation> timedOperationsList) {
        HashMap<String, ArrayList<TimedOperation>> timedOperationsByType = new HashMap<String, ArrayList<TimedOperation>>();
        for (TimedOperation to : timedOperationsList) {
            ArrayList<Object> toList;
            String toType = to.getType();
            if (timedOperationsByType.containsKey(toType)) {
                toList = timedOperationsByType.get(toType);
                toList.add(to);
                continue;
            }
            toList = new ArrayList();
            toList.add(to);
            timedOperationsByType.put(toType, toList);
        }
        return timedOperationsByType;
    }

    static {
        syncTimerStartObject = new Object(){};
    }
}

